/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.storegate;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.storegate.StoregateExceptionMappingService;
import ch.cyberduck.core.storegate.StoregateIdProvider;
import ch.cyberduck.core.storegate.StoregateSession;
import ch.cyberduck.core.storegate.io.swagger.client.ApiClient;
import ch.cyberduck.core.storegate.io.swagger.client.ApiException;
import ch.cyberduck.core.storegate.io.swagger.client.api.FilesApi;
import ch.cyberduck.core.storegate.io.swagger.client.model.File;

public class StoregateAttributesFinderFeature
implements AttributesFinder {
    private final StoregateSession session;
    private final StoregateIdProvider fileid;

    public StoregateAttributesFinderFeature(StoregateSession session, StoregateIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public PathAttributes find(Path file) throws BackgroundException {
        try {
            FilesApi files = new FilesApi((ApiClient)this.session.getClient());
            return this.toAttributes(files.filesGet_1(URIEncoder.encode((String)this.fileid.getPrefixedPath(file))));
        }
        catch (ApiException e) {
            throw new StoregateExceptionMappingService().map("Failure to read attributes of {0}", e, file);
        }
    }

    public PathAttributes toAttributes(File f) {
        PathAttributes attrs = new PathAttributes();
        if (0L != f.getModified().getMillis()) {
            attrs.setModificationDate(f.getModified().getMillis());
        } else {
            attrs.setModificationDate(f.getUploaded().getMillis());
        }
        if (0L != f.getCreated().getMillis()) {
            attrs.setCreationDate(f.getCreated().getMillis());
        } else {
            attrs.setCreationDate(f.getUploaded().getMillis());
        }
        attrs.setSize(f.getSize().longValue());
        if ((f.getFlags() & File.FlagsEnum.Locked.getValue()) == File.FlagsEnum.Locked.getValue()) {
            attrs.setLockId(Boolean.TRUE.toString());
        }
        return attrs;
    }
}

