/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dav;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.dav.DAVClient;
import ch.cyberduck.core.dav.DAVExceptionMappingService;
import ch.cyberduck.core.dav.DAVPathEncoder;
import ch.cyberduck.core.dav.DAVSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.http.HttpExceptionMappingService;
import ch.cyberduck.core.shared.DefaultUrlProvider;
import ch.cyberduck.core.transfer.TransferStatus;
import com.github.sardine.impl.SardineException;
import com.github.sardine.impl.handler.VoidResponseHandler;
import com.github.sardine.impl.methods.HttpMove;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicHeader;

public class DAVMoveFeature
implements Move {
    private final DAVSession session;

    public DAVMoveFeature(DAVSession session) {
        this.session = session;
    }

    public Path move(Path file, Path renamed, TransferStatus status, Delete.Callback callback, ConnectionCallback connectionCallback) throws BackgroundException {
        try {
            String target = new DefaultUrlProvider(this.session.getHost()).toUrl(renamed).find(DescriptiveUrl.Type.provider).getUrl();
            HttpMove move = new HttpMove(new DAVPathEncoder().encode(file), file.isDirectory() ? String.format("%s/", target) : target, true);
            if (status.getLockId() != null) {
                move.addHeader((Header)new BasicHeader("If", String.format("(<%s>)", status.getLockId())));
            }
            ((DAVClient)((Object)this.session.getClient())).execute((HttpRequestBase)move, new VoidResponseHandler());
            return new Path(renamed.getParent(), renamed.getName(), renamed.getType(), new PathAttributes(file.attributes()));
        }
        catch (SardineException e) {
            throw new DAVExceptionMappingService().map("Cannot rename {0}", e, file);
        }
        catch (IOException e) {
            throw new HttpExceptionMappingService().map(e, file);
        }
    }

    public boolean isRecursive(Path source, Path target) {
        return true;
    }

    public Move withDelete(Delete delete) {
        return this;
    }
}

