/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.threading;

import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.BackgroundActionRegistry;
import ch.cyberduck.core.threading.RegistryBackgroundAction;
import java.text.MessageFormat;

public class DisconnectBackgroundAction
extends RegistryBackgroundAction<Void> {
    private final Controller controller;
    private final SessionPool session;

    public DisconnectBackgroundAction(Controller controller, SessionPool session) {
        super(controller, session);
        this.controller = controller;
        this.session = session;
    }

    @Override
    public void prepare() {
        super.prepare();
    }

    @Override
    public Void run() throws BackgroundException {
        BackgroundActionRegistry registry = this.controller.getRegistry();
        for (BackgroundAction action : registry) {
            action.cancel();
        }
        this.session.evict();
        return null;
    }

    @Override
    public Void run(Session<?> session) throws BackgroundException {
        throw new ConnectionCanceledException();
    }

    @Override
    public String getActivity() {
        if (this.session == SessionPool.DISCONNECTED) {
            return super.getActivity();
        }
        return MessageFormat.format(LocaleFactory.localizedString("Disconnecting {0}", "Status"), BookmarkNameProvider.toString(this.session.getHost()));
    }
}

