/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.shared;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.shared.DefaultHomeFinderService;
import java.util.EnumSet;

public class PathContainerHomeFinderService
extends DefaultHomeFinderService {
    private final PathContainerService containerService;

    public PathContainerHomeFinderService(Session session, PathContainerService containerService) {
        super(session);
        this.containerService = containerService;
    }

    @Override
    public Path find() throws BackgroundException {
        Path home = super.find();
        if (this.containerService.isContainer(home)) {
            return new Path(home.getParent(), home.getName(), EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.directory));
        }
        return home;
    }

    @Override
    public Path find(Path root, String path) {
        Path home = super.find(root, path);
        if (this.containerService.isContainer(home)) {
            return new Path(home.getParent(), home.getName(), EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.directory));
        }
        return home;
    }
}

