/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.http;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.TransferCanceledException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.http.DelayedHttpEntity;
import ch.cyberduck.core.http.DelayedHttpEntityCallable;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.http.HttpWriteFeature;
import ch.cyberduck.core.shared.AppendWriteFeature;
import ch.cyberduck.core.threading.NamedThreadFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.worker.DefaultExceptionMappingService;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.apache.log4j.Logger;

public abstract class AbstractHttpWriteFeature<T>
extends AppendWriteFeature<T>
implements HttpWriteFeature<T> {
    private static final Logger log = Logger.getLogger(AbstractHttpWriteFeature.class);

    protected AbstractHttpWriteFeature(Session<?> session) {
        super(session);
    }

    public AbstractHttpWriteFeature(Find finder, AttributesFinder attributes) {
        super(finder, attributes);
    }

    @Override
    public HttpResponseOutputStream<T> write(Path file, TransferStatus status, final DelayedHttpEntityCallable<T> command) throws BackgroundException {
        return this.write(file, status, command, new DelayedHttpEntity(){

            @Override
            public long getContentLength() {
                return command.getContentLength();
            }
        });
    }

    public HttpResponseOutputStream<T> write(Path file, final TransferStatus status, final DelayedHttpEntityCallable<T> command, final DelayedHttpEntity entity) throws BackgroundException {
        final CountDownLatch entry = entity.getEntry();
        final CountDownLatch exit = new CountDownLatch(1);
        if (StringUtils.isNotBlank((CharSequence)status.getMime())) {
            entity.setContentType((Header)new BasicHeader("Content-Type", status.getMime()));
        } else {
            entity.setContentType("application/octet-stream");
        }
        final FutureHttpResponse target = new FutureHttpResponse(){

            @Override
            public void run() {
                try {
                    if (status.isCanceled()) {
                        throw new TransferCanceledException();
                    }
                    this.response = command.call(entity);
                }
                catch (Exception e) {
                    this.exception = e;
                }
                finally {
                    entry.countDown();
                    exit.countDown();
                }
            }
        };
        NamedThreadFactory factory = new NamedThreadFactory(String.format("http-%s", file.getName()));
        Thread t = factory.newThread(target);
        t.start();
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)entry);
        if (null != target.getException()) {
            if (target.getException() instanceof BackgroundException) {
                throw (BackgroundException)target.getException();
            }
            throw new DefaultExceptionMappingService().map(target.getException());
        }
        final OutputStream stream = entity.getStream();
        return new HttpResponseOutputStream<T>(stream){

            public void flush() throws IOException {
                stream.flush();
            }

            @Override
            public T getStatus() throws BackgroundException {
                if (status.isCanceled()) {
                    throw new TransferCanceledException();
                }
                Uninterruptibles.awaitUninterruptibly((CountDownLatch)exit);
                if (null != target.getException()) {
                    if (target.getException() instanceof BackgroundException) {
                        throw (BackgroundException)target.getException();
                    }
                    throw new DefaultExceptionMappingService().map(target.getException());
                }
                return target.getResponse();
            }
        };
    }

    @Override
    public abstract HttpResponseOutputStream<T> write(Path var1, TransferStatus var2, ConnectionCallback var3) throws BackgroundException;

    private abstract class FutureHttpResponse
    implements Runnable {
        Exception exception;
        T response;

        private FutureHttpResponse() {
        }

        public Exception getException() {
            return this.exception;
        }

        public T getResponse() {
            return this.response;
        }
    }
}

