/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.exception;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.StringAppender;
import java.util.EnumSet;
import java.util.Objects;

public class BackgroundException
extends Exception {
    private static final long serialVersionUID = -6114495291207129418L;
    private Path file = new Path(String.valueOf('/'), EnumSet.of(AbstractPath.Type.directory));
    private String message;
    private String detail;

    public BackgroundException() {
        this(null, null, null);
    }

    public BackgroundException(Throwable cause) {
        this(cause.getMessage(), cause);
    }

    public BackgroundException(String message, String detail) {
        this(message, detail, null);
    }

    public BackgroundException(String detail, Throwable cause) {
        this(null, detail, cause);
    }

    public BackgroundException(String message, String detail, Throwable cause) {
        super(cause);
        this.message = message;
        this.detail = detail;
    }

    public void setMessage(String title) {
        this.message = title;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    @Override
    public String getMessage() {
        return null == this.message ? LocaleFactory.localizedString("Unknown") : this.message;
    }

    public void setFile(Path file) {
        this.file = file;
    }

    public BackgroundException withFile(Path file) {
        this.file = file;
        return this;
    }

    public Path getFile() {
        return this.file;
    }

    public String getHelp() {
        return "";
    }

    public String getDetail() {
        return this.getDetail(true);
    }

    public String getDetail(boolean help) {
        StringAppender appender = new StringAppender();
        appender.append(this.detail);
        if (help) {
            appender.append(this.getHelp());
        }
        return appender.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("BackgroundException{");
        sb.append("file=").append(this.file);
        sb.append(", message='").append(this.message).append('\'');
        sb.append(", detail='").append(this.detail).append('\'');
        sb.append(", class='").append(this.getClass().getName()).append('\'');
        sb.append(", cause='").append(this.getCause()).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BackgroundException)) {
            return false;
        }
        BackgroundException that = (BackgroundException)o;
        if (this.getCause() != null ? !this.getCause().equals(that.getCause()) : that.getCause() != null) {
            return false;
        }
        return Objects.equals(this.detail, that.detail);
    }

    public int hashCode() {
        int result = this.detail != null ? this.detail.hashCode() : 0;
        result = 31 * result + (this.getCause() != null ? this.getCause().hashCode() : 0);
        return result;
    }
}

