/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googlestorage;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.googlestorage.GoogleStorageAttributesFinderFeature;
import ch.cyberduck.core.googlestorage.GoogleStorageExceptionMappingService;
import ch.cyberduck.core.googlestorage.GoogleStoragePathContainerService;
import ch.cyberduck.core.googlestorage.GoogleStorageSession;
import ch.cyberduck.core.transfer.TransferStatus;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.StorageObject;
import java.io.IOException;

public class GoogleStorageCopyFeature
implements Copy {
    private final PathContainerService containerService = new GoogleStoragePathContainerService();
    private final GoogleStorageSession session;

    public GoogleStorageCopyFeature(GoogleStorageSession session) {
        this.session = session;
    }

    public Path copy(Path source, Path target, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            StorageObject object = (StorageObject)((Storage)this.session.getClient()).objects().copy(this.containerService.getContainer(source).getName(), this.containerService.getKey(source), this.containerService.getContainer(target).getName(), this.containerService.getKey(target), (StorageObject)((Storage)this.session.getClient()).objects().get(this.containerService.getContainer(source).getName(), this.containerService.getKey(source)).execute()).execute();
            return new Path(target.getParent(), target.getName(), target.getType(), new GoogleStorageAttributesFinderFeature(this.session).toAttributes(object));
        }
        catch (IOException e) {
            throw new GoogleStorageExceptionMappingService().map("Cannot copy {0}", e, source);
        }
    }

    public boolean isRecursive(Path source, Path target) {
        return false;
    }

    public boolean isSupported(Path source, Path target) {
        return !this.containerService.isContainer(source) && !this.containerService.isContainer(target);
    }
}

