/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googlestorage;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Encryption;
import ch.cyberduck.core.googlestorage.GoogleStorageExceptionMappingService;
import ch.cyberduck.core.googlestorage.GoogleStoragePathContainerService;
import ch.cyberduck.core.googlestorage.GoogleStorageSession;
import ch.cyberduck.core.io.Checksum;
import com.google.api.client.util.DateTime;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.Bucket;
import com.google.api.services.storage.model.StorageObject;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public class GoogleStorageAttributesFinderFeature
implements AttributesFinder {
    private final PathContainerService containerService = new GoogleStoragePathContainerService();
    private final GoogleStorageSession session;

    public GoogleStorageAttributesFinderFeature(GoogleStorageSession session) {
        this.session = session;
    }

    public PathAttributes find(Path file) throws BackgroundException {
        if (file.isRoot()) {
            return PathAttributes.EMPTY;
        }
        try {
            if (this.containerService.isContainer(file)) {
                return this.toAttributes((Bucket)((Storage)this.session.getClient()).buckets().get(this.containerService.getContainer(file).getName()).execute());
            }
            return this.toAttributes((StorageObject)((Storage)this.session.getClient()).objects().get(this.containerService.getContainer(file).getName(), this.containerService.getKey(file)).execute());
        }
        catch (IOException e) {
            throw new GoogleStorageExceptionMappingService().map("Failure to read attributes of {0}", e, file);
        }
    }

    protected PathAttributes toAttributes(Bucket bucket) {
        PathAttributes attributes = new PathAttributes();
        attributes.setRegion(bucket.getLocation());
        attributes.setStorageClass(bucket.getStorageClass());
        attributes.setCreationDate(bucket.getTimeCreated().getValue());
        attributes.setETag(bucket.getEtag());
        if (bucket.getEncryption() != null) {
            attributes.setEncryption(new Encryption.Algorithm("AES256", bucket.getEncryption().getDefaultKmsKeyName()));
        }
        attributes.setRegion(bucket.getLocation());
        return attributes;
    }

    protected PathAttributes toAttributes(StorageObject object) {
        PathAttributes attributes = new PathAttributes();
        attributes.setSize(object.getSize().longValue());
        DateTime lastmodified = object.getTimeCreated();
        if (lastmodified != null) {
            attributes.setModificationDate(lastmodified.getValue());
        }
        attributes.setStorageClass(object.getStorageClass());
        if (StringUtils.isNotBlank((CharSequence)object.getEtag())) {
            attributes.setETag(object.getEtag());
        }
        if (object.getKmsKeyName() != null) {
            attributes.setEncryption(new Encryption.Algorithm("AES256", object.getKmsKeyName()){

                public String getDescription() {
                    return String.format("SSE-KMS (%s)", this.key);
                }
            });
        }
        attributes.setChecksum(Checksum.parse((String)object.getMd5Hash()));
        if (object.getMetadata() != null) {
            attributes.setMetadata(object.getMetadata());
        }
        return attributes;
    }
}

