/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.b2.B2ExceptionMappingService;
import ch.cyberduck.core.b2.B2FileidProvider;
import ch.cyberduck.core.b2.B2Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.io.Checksum;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import synapticloop.b2.B2ApiClient;
import synapticloop.b2.exception.B2ApiException;
import synapticloop.b2.response.B2FileResponse;

public class B2AttributesFinderFeature
implements AttributesFinder {
    private final B2Session session;
    private final B2FileidProvider fileid;

    public B2AttributesFinderFeature(B2Session session, B2FileidProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public PathAttributes find(Path file) throws BackgroundException {
        if (file.isRoot()) {
            return PathAttributes.EMPTY;
        }
        if (file.getType().contains(AbstractPath.Type.upload)) {
            return PathAttributes.EMPTY;
        }
        try {
            B2FileResponse info = ((B2ApiClient)this.session.getClient()).getFileInfo(this.fileid.getFileid(file, (ListProgressListener)new DisabledListProgressListener()));
            return this.toAttributes(info);
        }
        catch (B2ApiException e) {
            if (StringUtils.equals((CharSequence)"file_state_none", (CharSequence)e.getMessage())) {
                return PathAttributes.EMPTY;
            }
            throw new B2ExceptionMappingService().map("Failure to read attributes of {0}", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    protected PathAttributes toAttributes(B2FileResponse response) {
        PathAttributes attributes = new PathAttributes();
        attributes.setSize(response.getContentLength());
        if (response.getFileInfo().containsKey("large_file_sha1")) {
            attributes.setChecksum(Checksum.parse((String)((String)response.getFileInfo().get("large_file_sha1"))));
        } else {
            attributes.setChecksum(Checksum.parse((String)StringUtils.removeStart((String)StringUtils.lowerCase((String)response.getContentSha1(), (Locale)Locale.ROOT), (String)"unverified:")));
        }
        if (!response.getFileInfo().isEmpty()) {
            HashMap metadata = new HashMap();
            for (Map.Entry entry : response.getFileInfo().entrySet()) {
                metadata.put(entry.getKey(), entry.getValue());
            }
            attributes.setMetadata(metadata);
        }
        attributes.setVersionId(response.getFileId());
        if (response.getFileInfo().containsKey("src_last_modified_millis")) {
            attributes.setModificationDate(Long.valueOf((String)response.getFileInfo().get("src_last_modified_millis")).longValue());
        }
        return attributes;
    }

    public AttributesFinder withCache(Cache<Path> cache) {
        this.fileid.withCache((Cache)cache);
        return this;
    }
}

