/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.parsers;

import com.spectralogic.ds3client.commands.parsers.interfaces.AbstractResponseParser;
import com.spectralogic.ds3client.commands.parsers.utils.ResponseParserUtils;
import com.spectralogic.ds3client.commands.spectrads3.RegisterDs3TargetSpectraS3Response;
import com.spectralogic.ds3client.models.Ds3Target;
import com.spectralogic.ds3client.networking.WebResponse;
import com.spectralogic.ds3client.serializer.XmlOutput;
import java.io.IOException;
import java.io.InputStream;

public class RegisterDs3TargetSpectraS3ResponseParser
extends AbstractResponseParser<RegisterDs3TargetSpectraS3Response> {
    private final int[] expectedStatusCodes = new int[]{201};

    @Override
    public RegisterDs3TargetSpectraS3Response parseXmlResponse(WebResponse response) throws IOException {
        int statusCode = response.getStatusCode();
        if (ResponseParserUtils.validateStatusCode(statusCode, this.expectedStatusCodes)) {
            switch (statusCode) {
                case 201: {
                    try (InputStream inputStream = response.getResponseStream();){
                        Ds3Target result = XmlOutput.fromXml(inputStream, Ds3Target.class);
                        RegisterDs3TargetSpectraS3Response registerDs3TargetSpectraS3Response = new RegisterDs3TargetSpectraS3Response(result, this.getChecksum(), this.getChecksumType());
                        return registerDs3TargetSpectraS3Response;
                    }
                }
            }
            assert (false) : "validateStatusCode should have made it impossible to reach this line";
        }
        throw ResponseParserUtils.createFailedRequest(response, this.expectedStatusCodes);
    }
}

