/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledConnectionCallback;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Encryption;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.s3.S3AttributesFinderFeature;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.s3.S3ThresholdCopyFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class S3EncryptionFeature
implements Encryption {
    private final Preferences preferences = PreferencesFactory.get();
    private final PathContainerService containerService = new S3PathContainerService();
    private final S3Session session;
    public static final Encryption.Algorithm SSE_AES256 = new Encryption.Algorithm("AES256", null){

        public String getDescription() {
            return "SSE-S3 (AES-256)";
        }
    };

    public S3EncryptionFeature(S3Session session) {
        this.session = session;
    }

    public Set<Encryption.Algorithm> getKeys(Path file, LoginCallback prompt) throws BackgroundException {
        return new HashSet<Encryption.Algorithm>(Arrays.asList(Encryption.Algorithm.NONE, SSE_AES256));
    }

    public Encryption.Algorithm getDefault(Path file) {
        String key = String.format("s3.encryption.key.%s", this.containerService.getContainer(file).getName());
        if (StringUtils.isNotBlank((CharSequence)this.preferences.getProperty(key))) {
            return Encryption.Algorithm.fromString((String)this.preferences.getProperty(key));
        }
        String setting = this.preferences.getProperty("s3.encryption.algorithm");
        if (StringUtils.equals((CharSequence)S3EncryptionFeature.SSE_AES256.algorithm, (CharSequence)setting)) {
            return SSE_AES256;
        }
        return Encryption.Algorithm.NONE;
    }

    public Encryption.Algorithm getEncryption(Path file) throws BackgroundException {
        if (file.isFile() || file.isPlaceholder()) {
            try {
                return new S3AttributesFinderFeature(this.session).find(file).getEncryption();
            }
            catch (NotfoundException e) {
                if (file.isPlaceholder()) {
                    return Encryption.Algorithm.NONE;
                }
                throw e;
            }
        }
        return Encryption.Algorithm.NONE;
    }

    public void setEncryption(Path file, Encryption.Algorithm setting) throws BackgroundException {
        if (this.containerService.isContainer(file)) {
            String key = String.format("s3.encryption.key.%s", this.containerService.getContainer(file).getName());
            this.preferences.setProperty(key, setting.toString());
        }
        if (file.isFile() || file.isPlaceholder()) {
            try {
                S3ThresholdCopyFeature copy = new S3ThresholdCopyFeature(this.session);
                TransferStatus status = new TransferStatus();
                status.setEncryption(setting);
                status.setLength(file.attributes().getSize());
                copy.copy(file, file, status, (ConnectionCallback)new DisabledConnectionCallback());
            }
            catch (NotfoundException e) {
                if (file.isPlaceholder()) {
                    return;
                }
                throw e;
            }
        }
    }
}

