/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.iam;

import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.KeychainLoginService;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.PasswordStoreFactory;
import ch.cyberduck.core.auth.AWSCredentialsConfigurator;
import ch.cyberduck.core.aws.CustomClientConfiguration;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.LoginFailureException;
import ch.cyberduck.core.iam.AmazonServiceExceptionMappingService;
import ch.cyberduck.core.identity.IdentityConfiguration;
import ch.cyberduck.core.preferences.PreferencesFactory;
import com.amazonaws.AmazonClientException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.identitymanagement.AmazonIdentityManagement;
import com.amazonaws.services.identitymanagement.AmazonIdentityManagementClientBuilder;
import com.amazonaws.services.identitymanagement.model.AccessKeyMetadata;
import com.amazonaws.services.identitymanagement.model.CreateAccessKeyRequest;
import com.amazonaws.services.identitymanagement.model.CreateAccessKeyResult;
import com.amazonaws.services.identitymanagement.model.CreateUserRequest;
import com.amazonaws.services.identitymanagement.model.DeleteAccessKeyRequest;
import com.amazonaws.services.identitymanagement.model.DeleteUserPolicyRequest;
import com.amazonaws.services.identitymanagement.model.DeleteUserRequest;
import com.amazonaws.services.identitymanagement.model.EntityAlreadyExistsException;
import com.amazonaws.services.identitymanagement.model.GetUserRequest;
import com.amazonaws.services.identitymanagement.model.ListAccessKeysRequest;
import com.amazonaws.services.identitymanagement.model.ListAccessKeysResult;
import com.amazonaws.services.identitymanagement.model.ListUserPoliciesRequest;
import com.amazonaws.services.identitymanagement.model.ListUserPoliciesResult;
import com.amazonaws.services.identitymanagement.model.NoSuchEntityException;
import com.amazonaws.services.identitymanagement.model.PutUserPolicyRequest;
import com.amazonaws.services.identitymanagement.model.User;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class AmazonIdentityConfiguration
implements IdentityConfiguration {
    private static final Logger log = Logger.getLogger(AmazonIdentityConfiguration.class);
    private final Host bookmark;
    private static final String prefix = "iam.";
    public final ClientConfiguration configuration;

    public AmazonIdentityConfiguration(Host bookmark) {
        this.bookmark = bookmark;
        this.configuration = new CustomClientConfiguration(bookmark);
    }

    private <T> T authenticated(Authenticated<T> run, LoginCallback prompt) throws BackgroundException {
        LoginOptions options = new LoginOptions(this.bookmark.getProtocol());
        try {
            KeychainLoginService login = new KeychainLoginService(PasswordStoreFactory.get());
            login.validate(this.bookmark, LocaleFactory.localizedString((String)"AWS Identity and Access Management", (String)"S3"), prompt, options);
            return run.call();
        }
        catch (LoginFailureException failure) {
            this.bookmark.setCredentials(prompt.prompt(this.bookmark, this.bookmark.getCredentials().getUsername(), LocaleFactory.localizedString((String)"Login failed", (String)"Credentials"), failure.getMessage(), options));
            return this.authenticated(run, prompt);
        }
    }

    public void delete(final String username, LoginCallback prompt) throws BackgroundException {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Delete user %s", username));
        }
        this.authenticated(new Authenticated<Void>(){

            @Override
            public Void call() throws BackgroundException {
                PreferencesFactory.get().deleteProperty(String.format("%s%s", AmazonIdentityConfiguration.prefix, username));
                AmazonIdentityManagement client = AmazonIdentityConfiguration.this.client();
                try {
                    ListAccessKeysResult keys = client.listAccessKeys(new ListAccessKeysRequest().withUserName(username));
                    for (AccessKeyMetadata key : keys.getAccessKeyMetadata()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Delete access key %s for user %s", key, username));
                        }
                        client.deleteAccessKey(new DeleteAccessKeyRequest(username, key.getAccessKeyId()));
                    }
                    ListUserPoliciesResult policies = client.listUserPolicies(new ListUserPoliciesRequest(username));
                    for (String policy : policies.getPolicyNames()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Delete policy %s for user %s", policy, username));
                        }
                        client.deleteUserPolicy(new DeleteUserPolicyRequest(username, policy));
                    }
                    client.deleteUser(new DeleteUserRequest(username));
                }
                catch (NoSuchEntityException e) {
                    log.warn((Object)String.format("User %s already removed", username));
                }
                catch (AmazonClientException e) {
                    throw new AmazonServiceExceptionMappingService().map("Cannot write user configuration", e);
                }
                finally {
                    client.shutdown();
                }
                return null;
            }
        }, prompt);
    }

    public Credentials getCredentials(String username) {
        String key = PreferencesFactory.get().getProperty(String.format("%s%s", prefix, username));
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Lookup access key for user %s with %s", username, key));
        }
        if (null == key) {
            log.warn((Object)String.format("No access key found for user %s", username));
            return null;
        }
        return new Credentials(key, PasswordStoreFactory.get().getPassword(this.bookmark.getProtocol().getScheme(), this.bookmark.getPort(), this.bookmark.getHostname(), key));
    }

    public void create(final String username, final String policy, LoginCallback prompt) throws BackgroundException {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Create user %s with policy %s", username, policy));
        }
        this.authenticated(new Authenticated<Void>(){

            @Override
            public Void call() throws BackgroundException {
                AmazonIdentityManagement client = AmazonIdentityConfiguration.this.client();
                try {
                    User user;
                    try {
                        user = client.createUser(new CreateUserRequest().withUserName(username)).getUser();
                    }
                    catch (EntityAlreadyExistsException e) {
                        user = client.getUser(new GetUserRequest().withUserName(username)).getUser();
                    }
                    CreateAccessKeyResult key = client.createAccessKey(new CreateAccessKeyRequest().withUserName(user.getUserName()));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Created access key %s for user %s", key, username));
                    }
                    client.putUserPolicy(new PutUserPolicyRequest(user.getUserName(), "Policy", policy));
                    String id = key.getAccessKey().getAccessKeyId();
                    if (log.isInfoEnabled()) {
                        log.info((Object)String.format("Map user %s to access key %s", String.format("%s%s", AmazonIdentityConfiguration.prefix, username), id));
                    }
                    PreferencesFactory.get().setProperty(String.format("%s%s", AmazonIdentityConfiguration.prefix, username), id);
                    PasswordStoreFactory.get().addPassword(AmazonIdentityConfiguration.this.bookmark.getProtocol().getScheme(), AmazonIdentityConfiguration.this.bookmark.getPort(), AmazonIdentityConfiguration.this.bookmark.getHostname(), id, key.getAccessKey().getSecretAccessKey());
                }
                catch (AmazonClientException e) {
                    throw new AmazonServiceExceptionMappingService().map("Cannot write user configuration", e);
                }
                finally {
                    client.shutdown();
                }
                return null;
            }
        }, prompt);
    }

    private AmazonIdentityManagement client() {
        AmazonIdentityManagementClientBuilder builder = (AmazonIdentityManagementClientBuilder)((AmazonIdentityManagementClientBuilder)((AmazonIdentityManagementClientBuilder)AmazonIdentityManagementClientBuilder.standard().withCredentials(AWSCredentialsConfigurator.toAWSCredentialsProvider(this.bookmark.getCredentials()))).withClientConfiguration(this.configuration)).withRegion(Regions.DEFAULT_REGION);
        return (AmazonIdentityManagement)builder.build();
    }

    private static interface Authenticated<T>
    extends Callable<T> {
        @Override
        public T call() throws BackgroundException;
    }
}

