/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.zxcvbn;

import com.nulabinc.zxcvbn.AttackTimes;
import com.nulabinc.zxcvbn.Feedback;
import com.nulabinc.zxcvbn.Matching;
import com.nulabinc.zxcvbn.Scoring;
import com.nulabinc.zxcvbn.Strength;
import com.nulabinc.zxcvbn.TimeEstimates;
import com.nulabinc.zxcvbn.matchers.Match;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Zxcvbn {
    public Strength measure(String password) {
        return this.measure(password, null);
    }

    public Strength measure(String password, List<String> sanitizedInputs) {
        List<String> lowerSanitizedInputs;
        if (password == null) {
            throw new IllegalArgumentException("Password is null.");
        }
        if (sanitizedInputs != null && !sanitizedInputs.isEmpty()) {
            lowerSanitizedInputs = new ArrayList<String>(sanitizedInputs.size());
            for (String sanitizedInput : sanitizedInputs) {
                lowerSanitizedInputs.add(sanitizedInput.toLowerCase());
            }
        } else {
            lowerSanitizedInputs = Collections.emptyList();
        }
        long start = this.time();
        Matching matching = this.createMatching(lowerSanitizedInputs);
        List<Match> matches = matching.omnimatch(password);
        Strength strength = Scoring.mostGuessableMatchSequence(password, matches);
        strength.setCalcTime(this.time() - start);
        AttackTimes attackTimes = TimeEstimates.estimateAttackTimes(strength.getGuesses());
        strength.setCrackTimeSeconds(attackTimes.getCrackTimeSeconds());
        strength.setCrackTimesDisplay(attackTimes.getCrackTimesDisplay());
        strength.setScore(attackTimes.getScore());
        strength.setFeedback(Feedback.getFeedback(strength.getScore(), strength.getSequence()));
        return strength;
    }

    protected Matching createMatching(List<String> lowerSanitizedInputs) {
        return new Matching(lowerSanitizedInputs);
    }

    private long time() {
        return System.nanoTime();
    }
}

