/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.secret;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.freedesktop.dbus.DBusPath;
import org.freedesktop.dbus.ObjectPath;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.dbus.types.Variant;
import org.freedesktop.secret.Pair;
import org.freedesktop.secret.Secret;
import org.freedesktop.secret.Session;
import org.freedesktop.secret.interfaces.Service;

public class Service
extends org.freedesktop.secret.interfaces.Service {
    public static final List<Class<? extends DBusSignal>> signals = Arrays.asList(Service.CollectionCreated.class, Service.CollectionChanged.class, Service.CollectionDeleted.class);
    private Session session = null;

    public Service(DBusConnection connection) {
        super(connection, signals, "org.freedesktop.secrets", "/org/freedesktop/secrets", "org.freedesktop.Secret.Service");
    }

    @Override
    public Pair<Variant<byte[]>, ObjectPath> openSession(String algorithm, Variant input) {
        Object[] params = this.send("OpenSession", "sv", algorithm, input);
        this.session = new Session((DBusPath)((ObjectPath)params[1]), this);
        return new Pair<Object, Object>(params[0], params[1]);
    }

    @Override
    public Pair<ObjectPath, ObjectPath> createCollection(Map<String, Variant> properties, String alias) {
        String a = alias == null ? "" : alias;
        Object[] params = this.send("CreateCollection", "a{sv}s", properties, a);
        return new Pair<Object, Object>(params[0], params[1]);
    }

    @Override
    public Pair<ObjectPath, ObjectPath> createCollection(Map<String, Variant> properties) {
        return this.createCollection(properties, "");
    }

    @Override
    public Pair<List<ObjectPath>, List<ObjectPath>> searchItems(Map<String, String> attributes) {
        Object[] params = this.send("SearchItems", "a{ss}", attributes);
        return new Pair<Object, Object>(params[0], params[1]);
    }

    @Override
    public Pair<List<ObjectPath>, ObjectPath> unlock(List<ObjectPath> objects) {
        Object[] params = this.send("Unlock", "ao", objects);
        return new Pair<Object, Object>(params[0], params[1]);
    }

    @Override
    public Pair<List<ObjectPath>, ObjectPath> lock(List<ObjectPath> objects) {
        Object[] params = this.send("Lock", "ao", objects);
        return new Pair<Object, Object>(params[0], params[1]);
    }

    @Override
    public void lockService() {
        this.send("LockService", "", new Object[0]);
    }

    @Override
    public ObjectPath changeLock(ObjectPath collection) {
        Object[] params = this.send("ChangeLock", "o", collection);
        return (ObjectPath)params[0];
    }

    @Override
    public Map<ObjectPath, Secret> getSecrets(List<ObjectPath> items, ObjectPath session) {
        Object[] params = this.send("GetSecrets", "aoo", items, session);
        return (Map)params[0];
    }

    @Override
    public ObjectPath readAlias(String name) {
        Object[] params = this.send("ReadAlias", "s", name);
        return (ObjectPath)params[0];
    }

    @Override
    public void setAlias(String name, ObjectPath collection) {
        this.send("SetAlias", "so", name, collection);
    }

    @Override
    public List<ObjectPath> getCollections() {
        Variant response = this.getProperty("Collections");
        return (ArrayList)response.getValue();
    }

    public boolean isRemote() {
        return false;
    }

    @Override
    public String getObjectPath() {
        return "/org/freedesktop/secrets";
    }

    public Session getSession() {
        return this.session;
    }
}

