/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dropbox;

import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.dropbox.DropboxExceptionMappingService;
import ch.cyberduck.core.dropbox.DropboxSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.UnsupportedException;
import ch.cyberduck.core.features.PromptUrlProvider;
import com.dropbox.core.DbxException;
import com.dropbox.core.v2.DbxRawClientV2;
import com.dropbox.core.v2.sharing.DbxUserSharingRequests;
import com.dropbox.core.v2.sharing.RequestedVisibility;
import com.dropbox.core.v2.sharing.SharedLinkMetadata;
import com.dropbox.core.v2.sharing.SharedLinkSettings;
import java.net.URI;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public class DropboxPasswordShareUrlProvider
implements PromptUrlProvider<Void, Void> {
    private static final Logger log = Logger.getLogger(DropboxPasswordShareUrlProvider.class);
    private final DropboxSession session;

    public DropboxPasswordShareUrlProvider(DropboxSession session) {
        this.session = session;
    }

    public DescriptiveUrl toDownloadUrl(Path file, Void options, PasswordCallback callback) throws BackgroundException {
        try {
            SharedLinkMetadata share = new DbxUserSharingRequests((DbxRawClientV2)this.session.getClient()).createSharedLinkWithSettings(file.getAbsolute(), SharedLinkSettings.newBuilder().withRequestedVisibility(RequestedVisibility.PASSWORD).withLinkPassword(callback.prompt(this.session.getHost(), LocaleFactory.localizedString((String)"Passphrase", (String)"Cryptomator"), LocaleFactory.localizedString((String)"Provide additional login credentials", (String)"Credentials"), new LoginOptions().icon(this.session.getHost().getProtocol().disk())).getPassword()).build());
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Created shared link %s", share));
            }
            return new DescriptiveUrl(URI.create(share.getUrl()), DescriptiveUrl.Type.signed, MessageFormat.format(LocaleFactory.localizedString((String)"{0} URL"), LocaleFactory.localizedString((String)"Password Share", (String)"Dropbox")));
        }
        catch (DbxException e) {
            throw new DropboxExceptionMappingService().map(e);
        }
    }

    public DescriptiveUrl toUploadUrl(Path file, Void options, PasswordCallback callback) throws BackgroundException {
        throw new UnsupportedException();
    }

    public boolean isSupported(Path file, PromptUrlProvider.Type type) {
        switch (type) {
            case download: {
                return file.isFile();
            }
        }
        return false;
    }
}

