/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.azure;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.azure.AzureExceptionMappingService;
import ch.cyberduck.core.azure.AzurePathContainerService;
import ch.cyberduck.core.azure.AzureSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.preferences.PreferencesFactory;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.ResultContinuation;
import com.microsoft.azure.storage.ResultSegment;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.BlobListingDetails;
import com.microsoft.azure.storage.blob.BlobRequestOptions;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlobDirectory;
import com.microsoft.azure.storage.blob.ListBlobItem;
import java.net.URISyntaxException;
import java.util.EnumSet;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;

public class AzureObjectListService
implements ListService {
    private final AzureSession session;
    private final OperationContext context;
    private final PathContainerService containerService = new AzurePathContainerService();

    public AzureObjectListService(AzureSession session, OperationContext context) {
        this.session = session;
        this.context = context;
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        try {
            ResultSegment result;
            CloudBlobContainer container = ((CloudBlobClient)this.session.getClient()).getContainerReference(this.containerService.getContainer(directory).getName());
            AttributedList children = new AttributedList();
            ResultContinuation token = null;
            String prefix = "";
            if (!this.containerService.isContainer(directory) && !(prefix = this.containerService.getKey(directory)).endsWith(String.valueOf('/'))) {
                prefix = prefix + '/';
            }
            boolean hasDirectoryPlaceholder = this.containerService.isContainer(directory);
            do {
                BlobRequestOptions options = new BlobRequestOptions();
                result = container.listBlobsSegmented(prefix, false, EnumSet.noneOf(BlobListingDetails.class), Integer.valueOf(PreferencesFactory.get().getInteger("azure.listing.chunksize")), token, options, this.context);
                for (ListBlobItem object : result.getResults()) {
                    if (new Path(object.getUri().getPath(), EnumSet.of(AbstractPath.Type.directory)).equals((Object)directory)) {
                        hasDirectoryPlaceholder = true;
                        continue;
                    }
                    PathAttributes attributes = new PathAttributes();
                    if (object instanceof CloudBlob) {
                        CloudBlob blob = (CloudBlob)object;
                        attributes.setSize(blob.getProperties().getLength());
                        attributes.setModificationDate(blob.getProperties().getLastModified().getTime());
                        attributes.setETag(blob.getProperties().getEtag());
                        if (StringUtils.isNotBlank((CharSequence)blob.getProperties().getContentMD5())) {
                            attributes.setChecksum(Checksum.parse((String)Hex.encodeHexString((byte[])Base64.decodeBase64((String)blob.getProperties().getContentMD5()))));
                        }
                    }
                    EnumSet<AbstractPath.Type> types = object instanceof CloudBlobDirectory ? EnumSet.of(AbstractPath.Type.directory, AbstractPath.Type.placeholder) : EnumSet.of(AbstractPath.Type.file);
                    Path child = new Path(directory, PathNormalizer.name((String)object.getUri().getPath()), types, attributes);
                    children.add((Referenceable)child);
                }
                listener.chunk(directory, children);
                token = result.getContinuationToken();
            } while (result.getHasMoreResults());
            if (!hasDirectoryPlaceholder && children.isEmpty()) {
                throw new NotfoundException(directory.getAbsolute());
            }
            return children;
        }
        catch (StorageException e) {
            throw new AzureExceptionMappingService().map("Listing directory {0} failed", e, directory);
        }
        catch (URISyntaxException e) {
            throw new NotfoundException(e.getMessage(), (Throwable)e);
        }
    }

    public ListService withCache(Cache<Path> cache) {
        return this;
    }
}

