/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.b2.B2FileidProvider;
import ch.cyberduck.core.b2.B2LargeUploadService;
import ch.cyberduck.core.b2.B2Session;
import ch.cyberduck.core.b2.B2SingleUploadService;
import ch.cyberduck.core.b2.B2WriteFeature;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import org.apache.log4j.Logger;
import synapticloop.b2.response.BaseB2Response;

public class B2ThresholdUploadService
implements Upload<BaseB2Response> {
    private static final Logger log = Logger.getLogger(B2ThresholdUploadService.class);
    private final B2Session session;
    private final B2FileidProvider fileid;
    private Write<BaseB2Response> writer;
    private final Long threshold;

    public B2ThresholdUploadService(B2Session session, B2FileidProvider fileid) {
        this(session, fileid, PreferencesFactory.get().getLong("b2.upload.largeobject.threshold"));
    }

    public B2ThresholdUploadService(B2Session session, B2FileidProvider fileid, Long threshold) {
        this.session = session;
        this.fileid = fileid;
        this.writer = new B2WriteFeature(session, fileid);
        this.threshold = threshold;
    }

    public Write.Append append(Path file, Long length, Cache<Path> cache) throws BackgroundException {
        return new B2WriteFeature(this.session, this.fileid).append(file, length, cache);
    }

    public BaseB2Response upload(Path file, Local local, BandwidthThrottle throttle, StreamListener listener, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        if (this.threshold(status.getLength())) {
            return new B2LargeUploadService(this.session, this.fileid, this.writer, PreferencesFactory.get().getLong("b2.upload.largeobject.size"), PreferencesFactory.get().getInteger("b2.upload.largeobject.concurrency")).upload(file, local, throttle, listener, status, callback);
        }
        return (BaseB2Response)new B2SingleUploadService(this.writer).upload(file, local, throttle, listener, status, callback);
    }

    public Upload<BaseB2Response> withWriter(Write<BaseB2Response> writer) {
        this.writer = writer;
        return this;
    }

    protected boolean threshold(Long length) {
        if (length > this.threshold) {
            if (!PreferencesFactory.get().getBoolean("b2.upload.largeobject") && length < PreferencesFactory.get().getLong("b2.upload.largeobject.required.threshold")) {
                log.warn((Object)"Large upload is disabled with property b2.upload.largeobject.required.threshold");
                return false;
            }
            return true;
        }
        return false;
    }
}

