/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.nio;

import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.nio.LocalExceptionMappingService;
import ch.cyberduck.core.nio.LocalSession;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;

public class LocalDeleteFeature
implements Delete {
    private final LocalSession session;

    public LocalDeleteFeature(LocalSession session) {
        this.session = session;
    }

    public void delete(List<Path> files, PasswordCallback prompt, Delete.Callback callback) throws BackgroundException {
        for (Path file : files) {
            if (!file.isFile() && !file.isSymbolicLink()) continue;
            callback.delete(file);
            try {
                Files.delete(this.session.toPath(file));
            }
            catch (IOException e) {
                throw new LocalExceptionMappingService().map("Cannot delete {0}", e, file);
            }
        }
        for (Path file : files) {
            if (!file.isDirectory() || file.isSymbolicLink()) continue;
            callback.delete(file);
            try {
                Files.delete(this.session.toPath(file));
            }
            catch (IOException e) {
                throw new LocalExceptionMappingService().map("Cannot delete {0}", e, file);
            }
        }
    }

    public boolean isRecursive() {
        return false;
    }
}

