/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.IOException;
import java.net.URL;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveDrive;
import org.nuxeo.onedrive.client.OneDriveExpand;
import org.nuxeo.onedrive.client.OneDriveItem;
import org.nuxeo.onedrive.client.OneDriveJsonRequest;
import org.nuxeo.onedrive.client.OneDriveJsonResponse;
import org.nuxeo.onedrive.client.OneDriveResource;
import org.nuxeo.onedrive.client.QueryStringBuilder;

public class OneDriveRemoteItem
extends OneDriveItem {
    public OneDriveRemoteItem(OneDriveAPI api, OneDriveResource parent, String resourceIdentifier, OneDriveItem.ItemIdentifierType itemIdentifierType) {
        super(api, parent, resourceIdentifier, itemIdentifierType);
    }

    @Override
    public Metadata getMetadata(OneDriveExpand ... expands) throws IOException {
        QueryStringBuilder query = new QueryStringBuilder().set("expand", expands);
        URL url = this.getMetadataURL().build(this.getApi().getBaseURL(), query, new Object[0]);
        OneDriveJsonRequest request = new OneDriveJsonRequest(url, "GET");
        OneDriveJsonResponse response = request.sendRequest(this.getApi().getExecutor());
        return new Metadata(response.getContent());
    }

    public static Metadata parseJson(OneDriveAPI api, JsonObject nextObject) {
        OneDriveRemoteItem remoteItem;
        String id = nextObject.get("id").asString();
        OneDriveDrive drive = new OneDriveDrive(api, nextObject.get("parentReference").asObject().get("driveId").asString());
        OneDriveRemoteItem oneDriveRemoteItem = remoteItem = new OneDriveRemoteItem(api, drive, id, OneDriveItem.ItemIdentifierType.Id);
        oneDriveRemoteItem.getClass();
        return oneDriveRemoteItem.new Metadata(nextObject);
    }

    public class Metadata
    extends OneDriveItem.Metadata {
        private OneDriveItem.Metadata remoteItem;

        public OneDriveItem.Metadata getRemoteItem() {
            return this.remoteItem;
        }

        public Metadata(JsonObject json) {
            super(OneDriveRemoteItem.this, json);
        }

        @Override
        protected void parseMember(JsonObject.Member member) {
            JsonValue value = member.getValue();
            String memberName = member.getName();
            if ("remoteItem".equals(memberName)) {
                this.remoteItem = OneDriveItem.parseJson(OneDriveRemoteItem.this.getApi(), value.asObject());
            } else {
                super.parseMember(member);
            }
        }

        @Override
        public OneDriveRemoteItem getResource() {
            return OneDriveRemoteItem.this;
        }
    }
}

