/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.ParseException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.input.ProxyInputStream;
import org.nuxeo.onedrive.client.OneDriveAPIException;

public abstract class AbstractResponse<C>
implements Closeable {
    private final int responseCode;
    private final String responseMessage;
    private final String location;
    private final InputStream inputStream;
    private boolean closed;

    public AbstractResponse(int responseCode, String responseMessage, String location, InputStream inputStream) throws IOException {
        this.responseCode = responseCode;
        this.responseMessage = responseMessage;
        this.location = location;
        this.inputStream = inputStream;
        this.validate();
    }

    public abstract C getContent() throws IOException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JsonObject getError() throws IOException {
        try (InputStreamReader in = new InputStreamReader(this.getBody(), StandardCharsets.UTF_8);){
            JsonObject jsonObject = Json.parse((Reader)in).asObject();
            return jsonObject;
        }
        catch (ParseException e) {
            return null;
        }
    }

    protected InputStream getBody() throws OneDriveAPIException {
        return new ResponseInputStream();
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getLocation() {
        return this.location;
    }

    protected String getResponseMessage() {
        return this.responseMessage;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.inputStream.close();
        this.closed = true;
    }

    protected void validate() throws IOException {
        if (!this.isSuccess()) {
            JsonObject error = this.getError();
            if (null == error) {
                throw new OneDriveAPIException(this.responseMessage, this.responseCode);
            }
            throw new OneDriveAPIException(this.responseMessage, this.responseCode, error);
        }
    }

    public boolean isSuccess() {
        return this.responseCode >= 200 && this.responseCode < 300;
    }

    private class ResponseInputStream
    extends ProxyInputStream {
        public ResponseInputStream() {
            super(AbstractResponse.this.inputStream);
        }

        public void close() throws IOException {
            AbstractResponse.this.close();
        }
    }
}

