/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.query;

import java.util.List;
import org.irods.jargon.core.query.GenQueryField;
import org.irods.jargon.core.query.QueryConditionOperators;

class GenQueryBuilderCondition {
    private final String selectFieldColumnName;
    private final GenQueryField.SelectFieldSource selectFieldSource;
    private final String selectFieldNumericTranslation;
    private final QueryConditionOperators operator;
    private final String value;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GenQueryBuilderCondition");
        sb.append("\n\t selectFieldSource:");
        sb.append((Object)this.selectFieldSource);
        sb.append("\n\t selectFieldNumericTranslation:");
        sb.append(this.selectFieldNumericTranslation);
        sb.append("\n\t selectFieldColumnName:");
        sb.append(this.selectFieldColumnName);
        sb.append("\n\t operator:");
        sb.append((Object)this.operator);
        sb.append("\n\t value:");
        sb.append(this.value);
        return sb.toString();
    }

    static GenQueryBuilderCondition instance(String selectFieldColumnName, GenQueryField.SelectFieldSource selectFieldSource, String selectFieldNumericTranslation, QueryConditionOperators operator, String value) {
        return new GenQueryBuilderCondition(selectFieldColumnName, selectFieldSource, selectFieldNumericTranslation, operator, value);
    }

    static GenQueryBuilderCondition instanceForBetween(String selectFieldColumnName, GenQueryField.SelectFieldSource selectFieldSource, String selectFieldNumericTranslation, List<String> valuesWithoutQuotes) {
        if (valuesWithoutQuotes == null || valuesWithoutQuotes.isEmpty()) {
            throw new IllegalArgumentException("null or empty valueWithoutQuotes");
        }
        StringBuilder sb = new StringBuilder();
        for (String value : valuesWithoutQuotes) {
            sb.append("'");
            sb.append(value);
            sb.append("' ");
        }
        return new GenQueryBuilderCondition(selectFieldColumnName, selectFieldSource, selectFieldNumericTranslation, QueryConditionOperators.BETWEEN, sb.toString());
    }

    static GenQueryBuilderCondition instanceForIn(String selectFieldColumnName, GenQueryField.SelectFieldSource selectFieldSource, String selectFieldNumericTranslation, List<String> valuesWithoutQuotes) {
        if (valuesWithoutQuotes == null || valuesWithoutQuotes.isEmpty()) {
            throw new IllegalArgumentException("null or empty valueWithoutQuotes");
        }
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        boolean first = true;
        for (String value : valuesWithoutQuotes) {
            if (!first) {
                sb.append(",");
            }
            sb.append("'");
            sb.append(value);
            sb.append("'");
            first = false;
        }
        sb.append(")");
        return new GenQueryBuilderCondition(selectFieldColumnName, selectFieldSource, selectFieldNumericTranslation, QueryConditionOperators.IN, sb.toString());
    }

    private GenQueryBuilderCondition(String selectFieldColumnName, GenQueryField.SelectFieldSource selectFieldSource, String selectFieldNumericTranslation, QueryConditionOperators operator, String value) {
        this.selectFieldColumnName = selectFieldColumnName;
        this.selectFieldSource = selectFieldSource;
        this.selectFieldNumericTranslation = selectFieldNumericTranslation;
        this.operator = operator;
        this.value = value;
    }

    String getSelectFieldColumnName() {
        return this.selectFieldColumnName;
    }

    GenQueryField.SelectFieldSource getSelectFieldSource() {
        return this.selectFieldSource;
    }

    String getSelectFieldNumericTranslation() {
        return this.selectFieldNumericTranslation;
    }

    QueryConditionOperators getOperator() {
        return this.operator;
    }

    String getValue() {
        return this.value;
    }
}

