/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub.aohelper;

import java.util.ArrayList;
import java.util.List;
import org.irods.jargon.core.exception.DataNotFoundException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.protovalues.FilePermissionEnum;
import org.irods.jargon.core.protovalues.UserTypeEnum;
import org.irods.jargon.core.pub.aohelper.AOHelper;
import org.irods.jargon.core.pub.domain.Collection;
import org.irods.jargon.core.pub.domain.UserFilePermission;
import org.irods.jargon.core.query.AVUQueryElement;
import org.irods.jargon.core.query.BuilderQueryUtils;
import org.irods.jargon.core.query.CollectionAndDataObjectListingEntry;
import org.irods.jargon.core.query.GenQueryBuilderException;
import org.irods.jargon.core.query.IRODSGenQueryBuilder;
import org.irods.jargon.core.query.IRODSQueryResultRow;
import org.irods.jargon.core.query.IRODSQueryResultSetInterface;
import org.irods.jargon.core.query.JargonQueryException;
import org.irods.jargon.core.query.QueryConditionOperators;
import org.irods.jargon.core.query.RodsGenQueryEnum;
import org.irods.jargon.core.utils.IRODSDataConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionAOHelper
extends AOHelper {
    public static final Logger log = LoggerFactory.getLogger(CollectionAOHelper.class);

    public static String buildSelects() {
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        query.append(RodsGenQueryEnum.COL_COLL_ID.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_COLL_NAME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_COLL_PARENT_NAME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_COLL_OWNER_NAME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_COLL_OWNER_ZONE.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_COLL_MAP_ID.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_COLL_INHERITANCE.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_COLL_COMMENTS.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_COLL_CREATE_TIME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_COLL_MODIFY_TIME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_COLL_INFO1.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_COLL_INFO2.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_COLL_TYPE.getName());
        return query.toString();
    }

    public static void buildSelectsByAppendingToBuilder(IRODSGenQueryBuilder builder) throws GenQueryBuilderException {
        builder.addSelectAsGenQueryValue(RodsGenQueryEnum.COL_COLL_ID).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_COLL_NAME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_COLL_PARENT_NAME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_COLL_OWNER_NAME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_COLL_OWNER_ZONE).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_COLL_MAP_ID).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_COLL_INHERITANCE).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_COLL_COMMENTS).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_COLL_CREATE_TIME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_COLL_MODIFY_TIME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_COLL_INFO1).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_COLL_INFO2).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_COLL_TYPE);
    }

    public static String buildMetadataSelects() {
        StringBuilder query = new StringBuilder();
        query.append(RodsGenQueryEnum.COL_META_COLL_ATTR_NAME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_META_COLL_ATTR_VALUE.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_META_COLL_ATTR_UNITS.getName());
        return query.toString();
    }

    public static Collection buildCollectionFromResultSetRow(IRODSQueryResultRow row) throws JargonException {
        Collection collection = new Collection();
        collection.setCollectionId(IRODSDataConversionUtil.getIntOrZeroFromIRODSValue(row.getColumn(0)));
        collection.setCollectionName(row.getColumn(1));
        collection.setCollectionParentName(row.getColumn(2));
        collection.setCollectionOwnerName(row.getColumn(3));
        collection.setCollectionOwnerZone(row.getColumn(4));
        collection.setCollectionMapId(row.getColumn(5));
        collection.setCollectionInheritance(row.getColumn(6));
        collection.setComments(row.getColumn(7));
        collection.setCreatedAt(IRODSDataConversionUtil.getDateFromIRODSValue(row.getColumn(8)));
        collection.setModifiedAt(IRODSDataConversionUtil.getDateFromIRODSValue(row.getColumn(9)));
        collection.setInfo1(row.getColumn(10));
        collection.setInfo2(row.getColumn(11));
        collection.setInfo2(row.getColumn(11));
        collection.setLastResult(row.isLastResult());
        if (log.isInfoEnabled()) {
            log.info("collection built \n");
            log.info(collection.toString());
        }
        return collection;
    }

    public static StringBuilder buildConditionPart(AVUQueryElement queryElement) {
        StringBuilder queryCondition = new StringBuilder();
        if (queryElement.getAvuQueryPart() == AVUQueryElement.AVUQueryPart.ATTRIBUTE) {
            queryCondition.append(RodsGenQueryEnum.COL_META_COLL_ATTR_NAME.getName());
            queryCondition.append(' ');
            queryCondition.append(queryElement.getOperator().getOperatorValue());
            queryCondition.append(' ');
            queryCondition.append('\'');
            queryCondition.append(queryElement.getValue());
            queryCondition.append('\'');
        }
        if (queryElement.getAvuQueryPart() == AVUQueryElement.AVUQueryPart.VALUE) {
            queryCondition.append(RodsGenQueryEnum.COL_META_COLL_ATTR_VALUE.getName());
            queryCondition.append(' ');
            queryCondition.append(queryElement.getOperator().getOperatorValue());
            queryCondition.append(' ');
            queryCondition.append('\'');
            queryCondition.append(queryElement.getValue());
            queryCondition.append('\'');
        }
        if (queryElement.getAvuQueryPart() == AVUQueryElement.AVUQueryPart.UNITS) {
            queryCondition.append(RodsGenQueryEnum.COL_META_COLL_ATTR_UNITS.getName());
            queryCondition.append(' ');
            queryCondition.append(queryElement.getOperator().getOperatorValue());
            queryCondition.append(' ');
            queryCondition.append('\'');
            queryCondition.append(queryElement.getValue());
            queryCondition.append('\'');
        }
        return queryCondition;
    }

    public static void appendConditionPartToBuilderQuery(AVUQueryElement queryElement, IRODSGenQueryBuilder builder) throws JargonQueryException {
        if (queryElement.getAvuQueryPart() == AVUQueryElement.AVUQueryPart.ATTRIBUTE) {
            builder.addConditionAsGenQueryField(RodsGenQueryEnum.COL_META_COLL_ATTR_NAME, BuilderQueryUtils.translateAVUQueryElementOperatorToBuilderQueryCondition(queryElement), queryElement.getValue());
        } else if (queryElement.getAvuQueryPart() == AVUQueryElement.AVUQueryPart.VALUE) {
            builder.addConditionAsGenQueryField(RodsGenQueryEnum.COL_META_COLL_ATTR_VALUE, BuilderQueryUtils.translateAVUQueryElementOperatorToBuilderQueryCondition(queryElement), queryElement.getValue());
        } else if (queryElement.getAvuQueryPart() == AVUQueryElement.AVUQueryPart.UNITS) {
            builder.addConditionAsGenQueryField(RodsGenQueryEnum.COL_META_COLL_ATTR_UNITS, BuilderQueryUtils.translateAVUQueryElementOperatorToBuilderQueryCondition(queryElement), queryElement.getValue());
        } else {
            throw new JargonQueryException("unable to resolve AVU Query part");
        }
    }

    public static List<Collection> buildListFromResultSet(IRODSQueryResultSetInterface resultSet) throws JargonException {
        ArrayList<Collection> collections = new ArrayList<Collection>();
        for (IRODSQueryResultRow row : resultSet.getResults()) {
            collections.add(CollectionAOHelper.buildCollectionFromResultSetRow(row));
        }
        return collections;
    }

    public static CollectionAndDataObjectListingEntry buildCollectionListEntryFromResultSetRowForCollectionQuery(IRODSQueryResultRow row, int totalRecords) throws JargonException {
        CollectionAndDataObjectListingEntry entry = new CollectionAndDataObjectListingEntry();
        entry.setParentPath(row.getColumn(0));
        entry.setObjectType(CollectionAndDataObjectListingEntry.ObjectType.COLLECTION);
        entry.setPathOrName(row.getColumn(1));
        entry.setCreatedAt(IRODSDataConversionUtil.getDateFromIRODSValue(row.getColumn(2)));
        entry.setModifiedAt(IRODSDataConversionUtil.getDateFromIRODSValue(row.getColumn(3)));
        entry.setId(IRODSDataConversionUtil.getIntOrZeroFromIRODSValue(row.getColumn(4)));
        entry.setOwnerName(row.getColumn(5));
        entry.setOwnerZone(row.getColumn(6));
        entry.setSpecColType(IRODSDataConversionUtil.getCollectionTypeFromIRODSValue(row.getColumn(7)));
        entry.setCount(row.getRecordCount());
        entry.setTotalRecords(totalRecords);
        entry.setLastResult(row.isLastResult());
        log.debug("listing entry built {}", (Object)entry.toString());
        return entry;
    }

    public static CollectionAndDataObjectListingEntry buildCollectionListEntryFromResultSetRowForDataObjectQuery(IRODSQueryResultRow row, int totalRecords) throws JargonException {
        CollectionAndDataObjectListingEntry entry = new CollectionAndDataObjectListingEntry();
        entry.setParentPath(row.getColumn(0));
        entry.setObjectType(CollectionAndDataObjectListingEntry.ObjectType.DATA_OBJECT);
        entry.setPathOrName(row.getColumn(1));
        entry.setCreatedAt(IRODSDataConversionUtil.getDateFromIRODSValue(row.getColumn(2)));
        entry.setModifiedAt(IRODSDataConversionUtil.getDateFromIRODSValue(row.getColumn(3)));
        entry.setId(IRODSDataConversionUtil.getIntOrZeroFromIRODSValue(row.getColumn(4)));
        entry.setDataSize(IRODSDataConversionUtil.getLongOrZeroFromIRODSValue(row.getColumn(5)));
        entry.setOwnerName(row.getColumn(7));
        entry.setOwnerZone(row.getColumn(8));
        entry.setCount(row.getRecordCount());
        entry.setLastResult(row.isLastResult());
        entry.setTotalRecords(totalRecords);
        log.debug("listing entry built {}", (Object)entry.toString());
        return entry;
    }

    public static void buildSelectsNeededForCollectionsInCollectionsAndDataObjectsListingEntry(IRODSGenQueryBuilder builder) throws GenQueryBuilderException {
        if (builder == null) {
            throw new IllegalArgumentException("null builder");
        }
        builder.addSelectAsGenQueryValue(RodsGenQueryEnum.COL_COLL_PARENT_NAME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_COLL_NAME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_COLL_CREATE_TIME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_COLL_MODIFY_TIME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_COLL_ID).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_COLL_OWNER_NAME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_COLL_OWNER_ZONE).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_COLL_TYPE);
    }

    public static void buildInheritanceQueryForCollectionAbsolutePath(String absolutePathToCollection, IRODSGenQueryBuilder builder) throws JargonException {
        if (absolutePathToCollection == null || absolutePathToCollection.isEmpty()) {
            throw new IllegalArgumentException("null or empty absolutePathToCollection");
        }
        if (builder == null) {
            throw new IllegalArgumentException("null builder");
        }
        try {
            builder.addSelectAsGenQueryValue(RodsGenQueryEnum.COL_COLL_INHERITANCE).addConditionAsGenQueryField(RodsGenQueryEnum.COL_COLL_NAME, QueryConditionOperators.EQUAL, absolutePathToCollection);
        }
        catch (GenQueryBuilderException e) {
            throw new JargonException("error building inheritance query", e);
        }
    }

    public static void buildUserFilePermissionForCollection(List<UserFilePermission> userFilePermissions, IRODSQueryResultRow row, String irodsAbsolutePath) throws JargonException {
        UserFilePermission userFilePermission;
        try {
            userFilePermission = new UserFilePermission(row.getColumn(8), row.getColumn(11), FilePermissionEnum.valueOf(IRODSDataConversionUtil.getIntOrZeroFromIRODSValue(row.getColumn(10))), UserTypeEnum.RODS_UNKNOWN, row.getColumn(9));
        }
        catch (DataNotFoundException dnf) {
            log.warn("user info not found for permission for user:{}, this permission will not be added", (Object)row.getColumn(8));
            userFilePermission = new UserFilePermission(row.getColumn(8), row.getColumn(11), FilePermissionEnum.valueOf(IRODSDataConversionUtil.getIntOrZeroFromIRODSValue(row.getColumn(10))), UserTypeEnum.RODS_UNKNOWN, row.getColumn(9));
        }
        userFilePermissions.add(userFilePermission);
    }

    public static void buildUserFilePermissionForDataObject(List<UserFilePermission> userFilePermissions, IRODSQueryResultRow row, String irodsAbsolutePath, String currentZone) throws JargonException {
        UserFilePermission userFilePermission = new UserFilePermission(row.getColumn(9), row.getColumn(10), FilePermissionEnum.valueOf(IRODSDataConversionUtil.getIntOrZeroFromIRODSValue(row.getColumn(11))), UserTypeEnum.findTypeByString(row.getColumn(12)), row.getColumn(13));
        userFilePermissions.add(userFilePermission);
    }

    public static void buildACLQueryForCollectionName(String irodsCollectionAbsolutePath, IRODSGenQueryBuilder builder) throws JargonException {
        if (irodsCollectionAbsolutePath == null || irodsCollectionAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsCollectionAbsolutePath");
        }
        try {
            builder.addSelectAsGenQueryValue(RodsGenQueryEnum.COL_COLL_ACCESS_USER_NAME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_COLL_ACCESS_USER_ZONE).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_COLL_ACCESS_USER_ID).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_COLL_ACCESS_TYPE).addConditionAsGenQueryField(RodsGenQueryEnum.COL_COLL_NAME, QueryConditionOperators.EQUAL, irodsCollectionAbsolutePath);
        }
        catch (GenQueryBuilderException e) {
            throw new JargonException(e);
        }
    }
}

