/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.packinstr;

import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.AbstractIRODSPackingInstruction;
import org.irods.jargon.core.packinstr.Tag;

public class PamAuthRequestInp
extends AbstractIRODSPackingInstruction {
    public static final String PI_TAG = "pamAuthRequestInp_PI";
    public static final int PAM_API_NBR = 725;
    private final String userName;
    private final String password;
    private final int pamTimeToLive;

    public static PamAuthRequestInp instance(String userName, String password, int pamTimeToLive) {
        return new PamAuthRequestInp(userName, password, pamTimeToLive);
    }

    private PamAuthRequestInp(String userName, String password, int pamTimeToLive) {
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userId");
        }
        if (password == null || password.isEmpty()) {
            throw new IllegalArgumentException("null or empty password");
        }
        if (pamTimeToLive < 0) {
            throw new IllegalArgumentException("pamTimeToLive < 0");
        }
        this.userName = userName;
        this.password = password;
        this.pamTimeToLive = pamTimeToLive;
        this.setApiNumber(725);
    }

    @Override
    public Tag getTagValue() throws JargonException {
        Tag message = new Tag(PI_TAG);
        message.addTag("pamUser", this.userName);
        message.addTag("pamPassword", this.password);
        message.addTag("timeToLive", this.pamTimeToLive);
        return message;
    }
}

