/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.connection;

import org.irods.jargon.core.connection.AbstractIRODSMidLevelProtocol;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSConnectionFactory;
import org.irods.jargon.core.connection.IRODSMidLevelProtocolFactory;
import org.irods.jargon.core.connection.IRODSProtocolManager;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.connection.PipelineConfiguration;
import org.irods.jargon.core.exception.AuthenticationException;
import org.irods.jargon.core.exception.JargonException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IRODSSimpleProtocolManager
extends IRODSProtocolManager {
    private Logger log = LoggerFactory.getLogger(IRODSSimpleProtocolManager.class);

    public static IRODSSimpleProtocolManager instance() {
        return new IRODSSimpleProtocolManager();
    }

    public IRODSSimpleProtocolManager() {
        this.log.info("creating simple protocol manager");
    }

    @Override
    public AbstractIRODSMidLevelProtocol getIRODSProtocol(IRODSAccount irodsAccount, PipelineConfiguration pipelineConfiguration, IRODSSession irodsSession) throws AuthenticationException, JargonException {
        this.log.debug("creating an IRODSSimpleConnection for account:{}", (Object)irodsAccount);
        if (irodsAccount == null) {
            throw new IllegalArgumentException("null irodsAccount");
        }
        if (pipelineConfiguration == null) {
            throw new IllegalArgumentException("null pipelineConfiguration");
        }
        if (irodsSession == null) {
            throw new IllegalArgumentException("null irodsSession");
        }
        this.checkMidLevelProtocolFactory(irodsSession);
        return this.createNewProtocol(irodsAccount, pipelineConfiguration, irodsSession);
    }

    private synchronized void checkMidLevelProtocolFactory(IRODSSession irodsSession) throws JargonException {
        if (this.getIrodsMidLevelProtocolFactory() == null) {
            IRODSConnectionFactory irodsConnectionFactory = this.getIrodsConnectionFactoryProducingFactory().instance(irodsSession.getJargonProperties());
            this.setIrodsMidLevelProtocolFactory(new IRODSMidLevelProtocolFactory(irodsConnectionFactory, this.getAuthenticationFactory()));
        }
    }

    @Override
    public void returnIRODSProtocol(AbstractIRODSMidLevelProtocol irodsMidLevelProtocol) throws JargonException {
        this.log.debug("irodsMidLevelProtocol returned:{}", (Object)irodsMidLevelProtocol);
        irodsMidLevelProtocol.shutdown();
    }
}

