/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googledrive;

import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.googledrive.AbstractDriveListService;
import ch.cyberduck.core.googledrive.DriveFileidProvider;
import ch.cyberduck.core.googledrive.DriveSession;
import org.apache.commons.lang3.StringUtils;

public class FileidDriveListService
extends AbstractDriveListService {
    private final DriveFileidProvider provider;
    private final Path file;

    public FileidDriveListService(DriveSession session, DriveFileidProvider provider, Path file) {
        super(session, provider, 1);
        this.provider = provider;
        this.file = file;
    }

    @Override
    protected String query(Path directory, ListProgressListener listener) throws BackgroundException {
        String escaped = this.file.getName();
        escaped = StringUtils.replace((String)escaped, (String)"\\", (String)"\\\\");
        escaped = StringUtils.replace((String)escaped, (String)"'", (String)"\\'");
        return String.format("name = '%s' and '%s' in parents", escaped, this.provider.getFileid(directory, (ListProgressListener)new DisabledListProgressListener()));
    }
}

