/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googledrive;

import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.PreferencesUseragentProvider;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.UseragentProvider;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Home;
import ch.cyberduck.core.features.IdProvider;
import ch.cyberduck.core.features.Metadata;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.PromptUrlProvider;
import ch.cyberduck.core.features.Quota;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.features.Search;
import ch.cyberduck.core.features.Timestamp;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.googledrive.DriveAttributesFinderFeature;
import ch.cyberduck.core.googledrive.DriveBatchDeleteFeature;
import ch.cyberduck.core.googledrive.DriveCopyFeature;
import ch.cyberduck.core.googledrive.DriveDirectoryFeature;
import ch.cyberduck.core.googledrive.DriveExceptionMappingService;
import ch.cyberduck.core.googledrive.DriveFileidProvider;
import ch.cyberduck.core.googledrive.DriveFindFeature;
import ch.cyberduck.core.googledrive.DriveHomeFinderService;
import ch.cyberduck.core.googledrive.DriveListService;
import ch.cyberduck.core.googledrive.DriveMetadataFeature;
import ch.cyberduck.core.googledrive.DriveMoveFeature;
import ch.cyberduck.core.googledrive.DriveQuotaFeature;
import ch.cyberduck.core.googledrive.DriveReadFeature;
import ch.cyberduck.core.googledrive.DriveSearchFeature;
import ch.cyberduck.core.googledrive.DriveSharingUrlProvider;
import ch.cyberduck.core.googledrive.DriveTimestampFeature;
import ch.cyberduck.core.googledrive.DriveTouchFeature;
import ch.cyberduck.core.googledrive.DriveUploadFeature;
import ch.cyberduck.core.googledrive.DriveUrlProvider;
import ch.cyberduck.core.googledrive.DriveWriteFeature;
import ch.cyberduck.core.http.DefaultHttpRateLimiter;
import ch.cyberduck.core.http.HttpRateLimiter;
import ch.cyberduck.core.http.HttpSession;
import ch.cyberduck.core.http.RateLimitingHttpRequestInterceptor;
import ch.cyberduck.core.oauth.OAuth2ErrorResponseInterceptor;
import ch.cyberduck.core.oauth.OAuth2RequestInterceptor;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.ssl.ThreadLocalHostnameDelegatingTrustManager;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import ch.cyberduck.core.threading.CancelCallback;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.apache.v2.ApacheHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.About;
import java.io.IOException;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.log4j.Logger;

public class DriveSession
extends HttpSession<Drive> {
    private static final Logger log = Logger.getLogger(DriveSession.class);
    private ApacheHttpTransport transport;
    private final UseragentProvider useragent = new PreferencesUseragentProvider();
    private OAuth2RequestInterceptor authorizationService;
    private final DriveFileidProvider fileid = new DriveFileidProvider(this);

    public DriveSession(Host host, X509TrustManager trust, X509KeyManager key) {
        super(host, new ThreadLocalHostnameDelegatingTrustManager(trust, host.getHostname()), key);
    }

    protected Drive connect(Proxy proxy, HostKeyCallback callback, LoginCallback prompt) {
        HttpClientBuilder configuration = this.builder.build(proxy, (TranscriptListener)this, prompt);
        this.authorizationService = new OAuth2RequestInterceptor((HttpClient)configuration.build(), this.host.getProtocol()).withRedirectUri(this.host.getProtocol().getOAuthRedirectUrl());
        configuration.addInterceptorLast((HttpRequestInterceptor)this.authorizationService);
        configuration.setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)new OAuth2ErrorResponseInterceptor(this.host, this.authorizationService, prompt));
        configuration.addInterceptorLast((HttpRequestInterceptor)new RateLimitingHttpRequestInterceptor((HttpRateLimiter)new DefaultHttpRateLimiter((double)PreferencesFactory.get().getInteger("googledrive.limit.requests.second"))));
        this.transport = new ApacheHttpTransport((HttpClient)configuration.build());
        return new Drive.Builder((HttpTransport)this.transport, (JsonFactory)new JacksonFactory(), new HttpRequestInitializer(){

            public void initialize(HttpRequest request) {
                request.setSuppressUserAgentSuffix(true);
            }
        }).setApplicationName(this.useragent.get()).build();
    }

    public void login(Proxy proxy, LoginCallback prompt, CancelCallback cancel) throws BackgroundException {
        About about;
        this.authorizationService.setTokens(this.authorizationService.authorize(this.host, prompt, cancel));
        try {
            about = (About)((Drive)this.client).about().get().setFields("user").execute();
        }
        catch (IOException e) {
            throw new DriveExceptionMappingService().map(e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Authenticated as user %s", about.getUser()));
        }
        Credentials credentials = this.host.getCredentials();
        credentials.setUsername(about.getUser().getEmailAddress());
    }

    protected void logout() throws BackgroundException {
        try {
            this.transport.shutdown();
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public HttpClient getHttpClient() {
        return this.transport.getHttpClient();
    }

    public <T> T _getFeature(Class<T> type) {
        if (type == ListService.class) {
            return (T)new DriveListService(this, this.fileid);
        }
        if (type == Read.class) {
            return (T)new DriveReadFeature(this, this.fileid);
        }
        if (type == Write.class) {
            return (T)((Object)new DriveWriteFeature(this, this.fileid));
        }
        if (type == Upload.class) {
            return (T)((Object)new DriveUploadFeature(new DriveWriteFeature(this, this.fileid)));
        }
        if (type == Directory.class) {
            return (T)new DriveDirectoryFeature(this, this.fileid);
        }
        if (type == Delete.class) {
            return (T)new DriveBatchDeleteFeature(this, this.fileid);
        }
        if (type == Move.class) {
            return (T)new DriveMoveFeature(this, this.fileid);
        }
        if (type == Copy.class) {
            return (T)new DriveCopyFeature(this, this.fileid);
        }
        if (type == Touch.class) {
            return (T)new DriveTouchFeature(this, this.fileid);
        }
        if (type == UrlProvider.class) {
            return (T)new DriveUrlProvider();
        }
        if (type == PromptUrlProvider.class) {
            return (T)new DriveSharingUrlProvider(this, this.fileid);
        }
        if (type == Home.class) {
            return (T)((Object)new DriveHomeFinderService(this));
        }
        if (type == IdProvider.class) {
            return (T)this.fileid;
        }
        if (type == Quota.class) {
            return (T)new DriveQuotaFeature(this);
        }
        if (type == Timestamp.class) {
            return (T)((Object)new DriveTimestampFeature(this, this.fileid));
        }
        if (type == Metadata.class) {
            return (T)new DriveMetadataFeature(this, this.fileid);
        }
        if (type == Search.class) {
            return (T)new DriveSearchFeature(this, this.fileid);
        }
        if (type == Find.class) {
            return (T)new DriveFindFeature(this, this.fileid);
        }
        if (type == AttributesFinder.class) {
            return (T)new DriveAttributesFinderFeature(this, this.fileid);
        }
        return (T)super._getFeature(type);
    }
}

