/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.storegate.io.swagger.client.model;

import ch.cyberduck.core.storegate.io.swagger.client.model.ShareUser;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Item containing information about a public available share.")
public class PublicShareInfo {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="type")
    private TypeEnum type = null;
    @JsonProperty(value="fileAllowUpload")
    private Boolean fileAllowUpload = null;
    @JsonProperty(value="contentHidden")
    private Boolean contentHidden = null;
    @JsonProperty(value="mediaAllowDownload")
    private Boolean mediaAllowDownload = null;
    @JsonProperty(value="sharedBy")
    private ShareUser sharedBy = null;
    @JsonProperty(value="partnerId")
    private String partnerId = null;
    @JsonProperty(value="retailerId")
    private String retailerId = null;
    @JsonProperty(value="authMethod")
    private AuthMethodEnum authMethod = null;
    @JsonProperty(value="fileAllowOfficeOnline")
    private Boolean fileAllowOfficeOnline = null;
    @JsonProperty(value="fileAllowOfficeOnlineEdit")
    private Boolean fileAllowOfficeOnlineEdit = null;

    public PublicShareInfo id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The share id.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public PublicShareInfo name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The share name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PublicShareInfo type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="Indicated the sharetype")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public PublicShareInfo fileAllowUpload(Boolean fileAllowUpload) {
        this.fileAllowUpload = fileAllowUpload;
        return this;
    }

    @ApiModelProperty(value="Set to true if the file share allows upload.")
    public Boolean isFileAllowUpload() {
        return this.fileAllowUpload;
    }

    public void setFileAllowUpload(Boolean fileAllowUpload) {
        this.fileAllowUpload = fileAllowUpload;
    }

    public PublicShareInfo contentHidden(Boolean contentHidden) {
        this.contentHidden = contentHidden;
        return this;
    }

    @ApiModelProperty(value="Set to true if the file share allows upload but the content is hidden.")
    public Boolean isContentHidden() {
        return this.contentHidden;
    }

    public void setContentHidden(Boolean contentHidden) {
        this.contentHidden = contentHidden;
    }

    public PublicShareInfo mediaAllowDownload(Boolean mediaAllowDownload) {
        this.mediaAllowDownload = mediaAllowDownload;
        return this;
    }

    @ApiModelProperty(value="Set to true if the media share allows download of the original image.")
    public Boolean isMediaAllowDownload() {
        return this.mediaAllowDownload;
    }

    public void setMediaAllowDownload(Boolean mediaAllowDownload) {
        this.mediaAllowDownload = mediaAllowDownload;
    }

    public PublicShareInfo sharedBy(ShareUser sharedBy) {
        this.sharedBy = sharedBy;
        return this;
    }

    @ApiModelProperty(value="Information about the user that created the share")
    public ShareUser getSharedBy() {
        return this.sharedBy;
    }

    public void setSharedBy(ShareUser sharedBy) {
        this.sharedBy = sharedBy;
    }

    public PublicShareInfo partnerId(String partnerId) {
        this.partnerId = partnerId;
        return this;
    }

    @ApiModelProperty(value="The PartnerId, used for content/media/configuration")
    public String getPartnerId() {
        return this.partnerId;
    }

    public void setPartnerId(String partnerId) {
        this.partnerId = partnerId;
    }

    public PublicShareInfo retailerId(String retailerId) {
        this.retailerId = retailerId;
        return this;
    }

    @ApiModelProperty(value="The Reatiler, used for content/media/configuration")
    public String getRetailerId() {
        return this.retailerId;
    }

    public void setRetailerId(String retailerId) {
        this.retailerId = retailerId;
    }

    public PublicShareInfo authMethod(AuthMethodEnum authMethod) {
        this.authMethod = authMethod;
        return this;
    }

    @ApiModelProperty(value="")
    public AuthMethodEnum getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(AuthMethodEnum authMethod) {
        this.authMethod = authMethod;
    }

    public PublicShareInfo fileAllowOfficeOnline(Boolean fileAllowOfficeOnline) {
        this.fileAllowOfficeOnline = fileAllowOfficeOnline;
        return this;
    }

    @ApiModelProperty(value="Is view in Office Online allowed")
    public Boolean isFileAllowOfficeOnline() {
        return this.fileAllowOfficeOnline;
    }

    public void setFileAllowOfficeOnline(Boolean fileAllowOfficeOnline) {
        this.fileAllowOfficeOnline = fileAllowOfficeOnline;
    }

    public PublicShareInfo fileAllowOfficeOnlineEdit(Boolean fileAllowOfficeOnlineEdit) {
        this.fileAllowOfficeOnlineEdit = fileAllowOfficeOnlineEdit;
        return this;
    }

    @ApiModelProperty(value="Is edit in Office Online allowed")
    public Boolean isFileAllowOfficeOnlineEdit() {
        return this.fileAllowOfficeOnlineEdit;
    }

    public void setFileAllowOfficeOnlineEdit(Boolean fileAllowOfficeOnlineEdit) {
        this.fileAllowOfficeOnlineEdit = fileAllowOfficeOnlineEdit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublicShareInfo publicShareInfo = (PublicShareInfo)o;
        return Objects.equals(this.id, publicShareInfo.id) && Objects.equals(this.name, publicShareInfo.name) && Objects.equals((Object)this.type, (Object)publicShareInfo.type) && Objects.equals(this.fileAllowUpload, publicShareInfo.fileAllowUpload) && Objects.equals(this.contentHidden, publicShareInfo.contentHidden) && Objects.equals(this.mediaAllowDownload, publicShareInfo.mediaAllowDownload) && Objects.equals(this.sharedBy, publicShareInfo.sharedBy) && Objects.equals(this.partnerId, publicShareInfo.partnerId) && Objects.equals(this.retailerId, publicShareInfo.retailerId) && Objects.equals((Object)this.authMethod, (Object)publicShareInfo.authMethod) && Objects.equals(this.fileAllowOfficeOnline, publicShareInfo.fileAllowOfficeOnline) && Objects.equals(this.fileAllowOfficeOnlineEdit, publicShareInfo.fileAllowOfficeOnlineEdit);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.type, this.fileAllowUpload, this.contentHidden, this.mediaAllowDownload, this.sharedBy, this.partnerId, this.retailerId, this.authMethod, this.fileAllowOfficeOnline, this.fileAllowOfficeOnlineEdit});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PublicShareInfo {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    fileAllowUpload: ").append(this.toIndentedString(this.fileAllowUpload)).append("\n");
        sb.append("    contentHidden: ").append(this.toIndentedString(this.contentHidden)).append("\n");
        sb.append("    mediaAllowDownload: ").append(this.toIndentedString(this.mediaAllowDownload)).append("\n");
        sb.append("    sharedBy: ").append(this.toIndentedString(this.sharedBy)).append("\n");
        sb.append("    partnerId: ").append(this.toIndentedString(this.partnerId)).append("\n");
        sb.append("    retailerId: ").append(this.toIndentedString(this.retailerId)).append("\n");
        sb.append("    authMethod: ").append(this.toIndentedString((Object)this.authMethod)).append("\n");
        sb.append("    fileAllowOfficeOnline: ").append(this.toIndentedString(this.fileAllowOfficeOnline)).append("\n");
        sb.append("    fileAllowOfficeOnlineEdit: ").append(this.toIndentedString(this.fileAllowOfficeOnlineEdit)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AuthMethodEnum {
        NUMBER_0(0),
        NUMBER_1(1),
        NUMBER_2(2);

        private Integer value;

        private AuthMethodEnum(Integer value) {
            this.value = value;
        }

        @JsonValue
        public Integer getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AuthMethodEnum fromValue(String text) {
            for (AuthMethodEnum b : AuthMethodEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum TypeEnum {
        NUMBER_0(0),
        NUMBER_1(1),
        NUMBER_2(2),
        NUMBER_3(3);

        private Integer value;

        private TypeEnum(Integer value) {
            this.value = value;
        }

        @JsonValue
        public Integer getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

