/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.storegate.io.swagger.client.api;

import ch.cyberduck.core.storegate.io.swagger.client.ApiClient;
import ch.cyberduck.core.storegate.io.swagger.client.ApiException;
import ch.cyberduck.core.storegate.io.swagger.client.ApiResponse;
import ch.cyberduck.core.storegate.io.swagger.client.Configuration;
import ch.cyberduck.core.storegate.io.swagger.client.Pair;
import ch.cyberduck.core.storegate.io.swagger.client.model.CopyFileRequest;
import ch.cyberduck.core.storegate.io.swagger.client.model.CreateFolderRequest;
import ch.cyberduck.core.storegate.io.swagger.client.model.File;
import ch.cyberduck.core.storegate.io.swagger.client.model.FileContents;
import ch.cyberduck.core.storegate.io.swagger.client.model.FileVersion;
import ch.cyberduck.core.storegate.io.swagger.client.model.MoveFileRequest;
import ch.cyberduck.core.storegate.io.swagger.client.model.SearchFileContents;
import ch.cyberduck.core.storegate.io.swagger.client.model.UpdateFilePropertiesRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class FilesApi {
    private ApiClient apiClient;

    public FilesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FilesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public File filesCopy(String id, CopyFileRequest copyFileRequest) throws ApiException {
        return this.filesCopyWithHttpInfo(id, copyFileRequest).getData();
    }

    public ApiResponse<File> filesCopyWithHttpInfo(String id, CopyFileRequest copyFileRequest) throws ApiException {
        CopyFileRequest localVarPostBody = copyFileRequest;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling filesCopy");
        }
        if (copyFileRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'copyFileRequest' when calling filesCopy");
        }
        String localVarPath = "/v4/files/{id}/copy".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "text/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<File> localVarReturnType = new GenericType<File>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public File filesCreateFolder(CreateFolderRequest createFolderRequest) throws ApiException {
        return this.filesCreateFolderWithHttpInfo(createFolderRequest).getData();
    }

    public ApiResponse<File> filesCreateFolderWithHttpInfo(CreateFolderRequest createFolderRequest) throws ApiException {
        CreateFolderRequest localVarPostBody = createFolderRequest;
        if (createFolderRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'createFolderRequest' when calling filesCreateFolder");
        }
        String localVarPath = "/v4/files";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "text/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<File> localVarReturnType = new GenericType<File>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void filesDelete(String id) throws ApiException {
        this.filesDeleteWithHttpInfo(id);
    }

    public ApiResponse<Void> filesDeleteWithHttpInfo(String id) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling filesDelete");
        }
        String localVarPath = "/v4/files/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void filesDelete_0(String id, Integer version) throws ApiException {
        this.filesDelete_0WithHttpInfo(id, version);
    }

    public ApiResponse<Void> filesDelete_0WithHttpInfo(String id, Integer version) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling filesDelete_0");
        }
        if (version == null) {
            throw new ApiException(400, "Missing the required parameter 'version' when calling filesDelete_0");
        }
        String localVarPath = "/v4/files/{id}/versions/{version}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString())).replaceAll("\\{version\\}", this.apiClient.escapeString(version.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public FileContents filesGet(String path, Integer pageIndex, Integer pageSize, String sortExpression, Integer filter, Boolean includeHidden, Boolean includeParent) throws ApiException {
        return this.filesGetWithHttpInfo(path, pageIndex, pageSize, sortExpression, filter, includeHidden, includeParent).getData();
    }

    public ApiResponse<FileContents> filesGetWithHttpInfo(String path, Integer pageIndex, Integer pageSize, String sortExpression, Integer filter, Boolean includeHidden, Boolean includeParent) throws ApiException {
        Object localVarPostBody = null;
        if (path == null) {
            throw new ApiException(400, "Missing the required parameter 'path' when calling filesGet");
        }
        if (pageIndex == null) {
            throw new ApiException(400, "Missing the required parameter 'pageIndex' when calling filesGet");
        }
        if (pageSize == null) {
            throw new ApiException(400, "Missing the required parameter 'pageSize' when calling filesGet");
        }
        if (sortExpression == null) {
            throw new ApiException(400, "Missing the required parameter 'sortExpression' when calling filesGet");
        }
        if (filter == null) {
            throw new ApiException(400, "Missing the required parameter 'filter' when calling filesGet");
        }
        if (includeHidden == null) {
            throw new ApiException(400, "Missing the required parameter 'includeHidden' when calling filesGet");
        }
        if (includeParent == null) {
            throw new ApiException(400, "Missing the required parameter 'includeParent' when calling filesGet");
        }
        String localVarPath = "/v4/files/contents";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "path", path));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageIndex", pageIndex));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sortExpression", sortExpression));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "includeHidden", includeHidden));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "includeParent", includeParent));
        String[] localVarAccepts = new String[]{"application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<FileContents> localVarReturnType = new GenericType<FileContents>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public FileContents filesGetById(String id, Integer pageIndex, Integer pageSize, String sortExpression, Integer filter, Boolean includeHidden, Boolean includeParent) throws ApiException {
        return this.filesGetByIdWithHttpInfo(id, pageIndex, pageSize, sortExpression, filter, includeHidden, includeParent).getData();
    }

    public ApiResponse<FileContents> filesGetByIdWithHttpInfo(String id, Integer pageIndex, Integer pageSize, String sortExpression, Integer filter, Boolean includeHidden, Boolean includeParent) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling filesGetById");
        }
        if (pageIndex == null) {
            throw new ApiException(400, "Missing the required parameter 'pageIndex' when calling filesGetById");
        }
        if (pageSize == null) {
            throw new ApiException(400, "Missing the required parameter 'pageSize' when calling filesGetById");
        }
        if (sortExpression == null) {
            throw new ApiException(400, "Missing the required parameter 'sortExpression' when calling filesGetById");
        }
        if (filter == null) {
            throw new ApiException(400, "Missing the required parameter 'filter' when calling filesGetById");
        }
        if (includeHidden == null) {
            throw new ApiException(400, "Missing the required parameter 'includeHidden' when calling filesGetById");
        }
        if (includeParent == null) {
            throw new ApiException(400, "Missing the required parameter 'includeParent' when calling filesGetById");
        }
        String localVarPath = "/v4/files/{id}/contents".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageIndex", pageIndex));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sortExpression", sortExpression));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "includeHidden", includeHidden));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "includeParent", includeParent));
        String[] localVarAccepts = new String[]{"application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<FileContents> localVarReturnType = new GenericType<FileContents>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Long filesGetFolderSize(String id) throws ApiException {
        return this.filesGetFolderSizeWithHttpInfo(id).getData();
    }

    public ApiResponse<Long> filesGetFolderSizeWithHttpInfo(String id) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling filesGetFolderSize");
        }
        String localVarPath = "/v4/files/{id}/size".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<Long> localVarReturnType = new GenericType<Long>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<File> filesGetRandomPhotos(String id, Integer numberOfPhotos) throws ApiException {
        return this.filesGetRandomPhotosWithHttpInfo(id, numberOfPhotos).getData();
    }

    public ApiResponse<List<File>> filesGetRandomPhotosWithHttpInfo(String id, Integer numberOfPhotos) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling filesGetRandomPhotos");
        }
        String localVarPath = "/v4/files/{id}/randomphotos".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "numberOfPhotos", numberOfPhotos));
        String[] localVarAccepts = new String[]{"application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<List<File>> localVarReturnType = new GenericType<List<File>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public SearchFileContents filesGetRecent(Integer pageIndex, Integer pageSize, Integer filter, String sortExpression, Boolean reversed) throws ApiException {
        return this.filesGetRecentWithHttpInfo(pageIndex, pageSize, filter, sortExpression, reversed).getData();
    }

    public ApiResponse<SearchFileContents> filesGetRecentWithHttpInfo(Integer pageIndex, Integer pageSize, Integer filter, String sortExpression, Boolean reversed) throws ApiException {
        Object localVarPostBody = null;
        if (pageIndex == null) {
            throw new ApiException(400, "Missing the required parameter 'pageIndex' when calling filesGetRecent");
        }
        if (pageSize == null) {
            throw new ApiException(400, "Missing the required parameter 'pageSize' when calling filesGetRecent");
        }
        if (filter == null) {
            throw new ApiException(400, "Missing the required parameter 'filter' when calling filesGetRecent");
        }
        String localVarPath = "/v4/files/recent";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageIndex", pageIndex));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sortExpression", sortExpression));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "reversed", reversed));
        String[] localVarAccepts = new String[]{"application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<SearchFileContents> localVarReturnType = new GenericType<SearchFileContents>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<FileVersion> filesGetResourceVersions(String id) throws ApiException {
        return this.filesGetResourceVersionsWithHttpInfo(id).getData();
    }

    public ApiResponse<List<FileVersion>> filesGetResourceVersionsWithHttpInfo(String id) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling filesGetResourceVersions");
        }
        String localVarPath = "/v4/files/{id}/versions".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<List<FileVersion>> localVarReturnType = new GenericType<List<FileVersion>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public File filesGet_0(String id) throws ApiException {
        return this.filesGet_0WithHttpInfo(id).getData();
    }

    public ApiResponse<File> filesGet_0WithHttpInfo(String id) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling filesGet_0");
        }
        String localVarPath = "/v4/files/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<File> localVarReturnType = new GenericType<File>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public File filesGet_1(String path) throws ApiException {
        return this.filesGet_1WithHttpInfo(path).getData();
    }

    public ApiResponse<File> filesGet_1WithHttpInfo(String path) throws ApiException {
        Object localVarPostBody = null;
        if (path == null) {
            throw new ApiException(400, "Missing the required parameter 'path' when calling filesGet_1");
        }
        String localVarPath = "/v4/files";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "path", path));
        String[] localVarAccepts = new String[]{"application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<File> localVarReturnType = new GenericType<File>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void filesMove(String id, MoveFileRequest moveFileRequest) throws ApiException {
        this.filesMoveWithHttpInfo(id, moveFileRequest);
    }

    public ApiResponse<Void> filesMoveWithHttpInfo(String id, MoveFileRequest moveFileRequest) throws ApiException {
        MoveFileRequest localVarPostBody = moveFileRequest;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling filesMove");
        }
        if (moveFileRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'moveFileRequest' when calling filesMove");
        }
        String localVarPath = "/v4/files/{id}/move".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "text/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public SearchFileContents filesSearch(String searchCriteria, String searchRoot, Integer pageIndex, Integer pageSize, String sortExpression) throws ApiException {
        return this.filesSearchWithHttpInfo(searchCriteria, searchRoot, pageIndex, pageSize, sortExpression).getData();
    }

    public ApiResponse<SearchFileContents> filesSearchWithHttpInfo(String searchCriteria, String searchRoot, Integer pageIndex, Integer pageSize, String sortExpression) throws ApiException {
        Object localVarPostBody = null;
        if (searchCriteria == null) {
            throw new ApiException(400, "Missing the required parameter 'searchCriteria' when calling filesSearch");
        }
        if (searchRoot == null) {
            throw new ApiException(400, "Missing the required parameter 'searchRoot' when calling filesSearch");
        }
        if (pageIndex == null) {
            throw new ApiException(400, "Missing the required parameter 'pageIndex' when calling filesSearch");
        }
        if (pageSize == null) {
            throw new ApiException(400, "Missing the required parameter 'pageSize' when calling filesSearch");
        }
        if (sortExpression == null) {
            throw new ApiException(400, "Missing the required parameter 'sortExpression' when calling filesSearch");
        }
        String localVarPath = "/v4/files/search";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "searchCriteria", searchCriteria));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "searchRoot", searchRoot));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageIndex", pageIndex));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sortExpression", sortExpression));
        String[] localVarAccepts = new String[]{"application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<SearchFileContents> localVarReturnType = new GenericType<SearchFileContents>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public File filesUpdateFile(String id, UpdateFilePropertiesRequest updateFilePropertiesRequest) throws ApiException {
        return this.filesUpdateFileWithHttpInfo(id, updateFilePropertiesRequest).getData();
    }

    public ApiResponse<File> filesUpdateFileWithHttpInfo(String id, UpdateFilePropertiesRequest updateFilePropertiesRequest) throws ApiException {
        UpdateFilePropertiesRequest localVarPostBody = updateFilePropertiesRequest;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling filesUpdateFile");
        }
        if (updateFilePropertiesRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'updateFilePropertiesRequest' when calling filesUpdateFile");
        }
        String localVarPath = "/v4/files/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "text/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<File> localVarReturnType = new GenericType<File>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

