/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.storegate.io.swagger.client.api;

import ch.cyberduck.core.storegate.io.swagger.client.ApiClient;
import ch.cyberduck.core.storegate.io.swagger.client.ApiException;
import ch.cyberduck.core.storegate.io.swagger.client.ApiResponse;
import ch.cyberduck.core.storegate.io.swagger.client.Configuration;
import ch.cyberduck.core.storegate.io.swagger.client.Pair;
import ch.cyberduck.core.storegate.io.swagger.client.model.CreateFileShareRequest;
import ch.cyberduck.core.storegate.io.swagger.client.model.FileShare;
import ch.cyberduck.core.storegate.io.swagger.client.model.ShareContents;
import ch.cyberduck.core.storegate.io.swagger.client.model.ShareMailRequest;
import ch.cyberduck.core.storegate.io.swagger.client.model.UpdateShareRequest;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class FileSharesApi {
    private ApiClient apiClient;

    public FileSharesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FileSharesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void fileSharesDelete(String id) throws ApiException {
        this.fileSharesDeleteWithHttpInfo(id);
    }

    public ApiResponse<Void> fileSharesDeleteWithHttpInfo(String id) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling fileSharesDelete");
        }
        String localVarPath = "/v4/fileshares/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public ShareContents fileSharesGet(Integer pageIndex, Integer pageSize, String sortExpression) throws ApiException {
        return this.fileSharesGetWithHttpInfo(pageIndex, pageSize, sortExpression).getData();
    }

    public ApiResponse<ShareContents> fileSharesGetWithHttpInfo(Integer pageIndex, Integer pageSize, String sortExpression) throws ApiException {
        Object localVarPostBody = null;
        if (pageIndex == null) {
            throw new ApiException(400, "Missing the required parameter 'pageIndex' when calling fileSharesGet");
        }
        if (pageSize == null) {
            throw new ApiException(400, "Missing the required parameter 'pageSize' when calling fileSharesGet");
        }
        if (sortExpression == null) {
            throw new ApiException(400, "Missing the required parameter 'sortExpression' when calling fileSharesGet");
        }
        String localVarPath = "/v4/fileshares";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageIndex", pageIndex));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sortExpression", sortExpression));
        String[] localVarAccepts = new String[]{"application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<ShareContents> localVarReturnType = new GenericType<ShareContents>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public FileShare fileSharesGetByFileId(String id) throws ApiException {
        return this.fileSharesGetByFileIdWithHttpInfo(id).getData();
    }

    public ApiResponse<FileShare> fileSharesGetByFileIdWithHttpInfo(String id) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling fileSharesGetByFileId");
        }
        String localVarPath = "/v4/fileshares/fileid/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<FileShare> localVarReturnType = new GenericType<FileShare>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public FileShare fileSharesGetById(String id) throws ApiException {
        return this.fileSharesGetByIdWithHttpInfo(id).getData();
    }

    public ApiResponse<FileShare> fileSharesGetByIdWithHttpInfo(String id) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling fileSharesGetById");
        }
        String localVarPath = "/v4/fileshares/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<FileShare> localVarReturnType = new GenericType<FileShare>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public FileShare fileSharesPost(CreateFileShareRequest createShareRequest) throws ApiException {
        return this.fileSharesPostWithHttpInfo(createShareRequest).getData();
    }

    public ApiResponse<FileShare> fileSharesPostWithHttpInfo(CreateFileShareRequest createShareRequest) throws ApiException {
        CreateFileShareRequest localVarPostBody = createShareRequest;
        if (createShareRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'createShareRequest' when calling fileSharesPost");
        }
        String localVarPath = "/v4/fileshares";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "text/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<FileShare> localVarReturnType = new GenericType<FileShare>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public FileShare fileSharesPost_0(String id) throws ApiException {
        return this.fileSharesPost_0WithHttpInfo(id).getData();
    }

    public ApiResponse<FileShare> fileSharesPost_0WithHttpInfo(String id) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling fileSharesPost_0");
        }
        String localVarPath = "/v4/fileshares/fileid/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<FileShare> localVarReturnType = new GenericType<FileShare>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public FileShare fileSharesPut(String id, UpdateShareRequest updateFileShareRequest) throws ApiException {
        return this.fileSharesPutWithHttpInfo(id, updateFileShareRequest).getData();
    }

    public ApiResponse<FileShare> fileSharesPutWithHttpInfo(String id, UpdateShareRequest updateFileShareRequest) throws ApiException {
        UpdateShareRequest localVarPostBody = updateFileShareRequest;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling fileSharesPut");
        }
        if (updateFileShareRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'updateFileShareRequest' when calling fileSharesPut");
        }
        String localVarPath = "/v4/fileshares/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "text/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<FileShare> localVarReturnType = new GenericType<FileShare>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void fileSharesSendShareMail(String id, ShareMailRequest shareMailRequest) throws ApiException {
        this.fileSharesSendShareMailWithHttpInfo(id, shareMailRequest);
    }

    public ApiResponse<Void> fileSharesSendShareMailWithHttpInfo(String id, ShareMailRequest shareMailRequest) throws ApiException {
        ShareMailRequest localVarPostBody = shareMailRequest;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling fileSharesSendShareMail");
        }
        if (shareMailRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'shareMailRequest' when calling fileSharesSendShareMail");
        }
        String localVarPath = "/v4/fileshares/{id}/mail".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "text/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }
}

