/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.storegate;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.PathRelativizer;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.SimplePathPredicate;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.IdProvider;
import ch.cyberduck.core.storegate.StoregateExceptionMappingService;
import ch.cyberduck.core.storegate.StoregateSession;
import ch.cyberduck.core.storegate.io.swagger.client.ApiClient;
import ch.cyberduck.core.storegate.io.swagger.client.ApiException;
import ch.cyberduck.core.storegate.io.swagger.client.api.FilesApi;
import ch.cyberduck.core.storegate.io.swagger.client.model.File;
import ch.cyberduck.core.storegate.io.swagger.client.model.RootFolder;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;

public class StoregateIdProvider
implements IdProvider {
    private final StoregateSession session;
    private Cache<Path> cache = PathCache.empty();

    public StoregateIdProvider(StoregateSession session) {
        this.session = session;
    }

    public String getFileid(Path file, ListProgressListener listener) throws BackgroundException {
        AttributedList list;
        Path found;
        if (StringUtils.isNotBlank((CharSequence)file.attributes().getVersionId())) {
            return file.attributes().getVersionId();
        }
        if (this.cache.isCached((Referenceable)file.getParent()) && null != (found = (Path)(list = this.cache.get((Referenceable)file.getParent())).find((Predicate)new SimplePathPredicate(file))) && StringUtils.isNotBlank((CharSequence)found.attributes().getVersionId())) {
            return this.set(file, found.attributes().getVersionId());
        }
        try {
            File f = new FilesApi((ApiClient)this.session.getClient()).filesGet_1(this.getPrefixedPath(file));
            return this.set(file, f.getId());
        }
        catch (ApiException e) {
            throw new StoregateExceptionMappingService().map(e);
        }
    }

    protected String set(Path file, String id) {
        file.attributes().setVersionId(id);
        return id;
    }

    public StoregateIdProvider withCache(Cache<Path> cache) {
        this.cache = cache;
        return this;
    }

    private String getPrefixedPath(Path file) {
        String root = new PathContainerService().getContainer(file).getAbsolute();
        String path = PathRelativizer.relativize((String)root, (String)file.getAbsolute());
        for (RootFolder r : this.session.roots()) {
            if (!root.endsWith(r.getName())) continue;
            return String.format("%s/%s", r.getPath(), path);
        }
        return file.getAbsolute();
    }
}

