/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.openstack;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AsciiRandomStringService;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.openstack.SwiftExceptionMappingService;
import ch.cyberduck.core.openstack.SwiftSession;
import ch.cyberduck.core.shared.OneTimeSchedulerFeature;
import ch.iterate.openstack.swift.Client;
import ch.iterate.openstack.swift.exception.GenericException;
import ch.iterate.openstack.swift.model.AccountInfo;
import ch.iterate.openstack.swift.model.Region;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SwiftAccountLoader
extends OneTimeSchedulerFeature<Map<Region, AccountInfo>> {
    private static final Logger log = Logger.getLogger(SwiftAccountLoader.class);
    private final SwiftSession session;

    public SwiftAccountLoader(SwiftSession session) {
        super(new Path(String.valueOf('/'), EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.directory)));
        this.session = session;
    }

    protected Map<Region, AccountInfo> operate(PasswordCallback callback, Path file) throws BackgroundException {
        try {
            ConcurrentHashMap<Region, AccountInfo> accounts = new ConcurrentHashMap<Region, AccountInfo>();
            for (Region region : ((Client)this.session.getClient()).getRegions()) {
                AccountInfo info = ((Client)this.session.getClient()).getAccountInfo(region);
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Signing key is %s", info.getTempUrlKey()));
                }
                if (StringUtils.isBlank((CharSequence)info.getTempUrlKey())) {
                    try {
                        String key = new AsciiRandomStringService().random();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Set acccount temp URL key to %s", key));
                        }
                        ((Client)this.session.getClient()).updateAccountMetadata(region, Collections.singletonMap("X-Account-Meta-Temp-URL-Key", key));
                        info.setTempUrlKey(key);
                    }
                    catch (GenericException e) {
                        log.warn((Object)String.format("Ignore failure %s updating account metadata", new Object[]{e}));
                    }
                }
                accounts.put(region, info);
            }
            return accounts;
        }
        catch (GenericException e) {
            throw new SwiftExceptionMappingService().map(e);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }
}

