/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault.registry;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Vault;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.vault.DefaultVaultRegistry;
import ch.cyberduck.core.vault.VaultLookupListener;
import ch.cyberduck.core.vault.VaultRegistry;
import ch.cyberduck.core.vault.VaultUnlockCancelException;
import java.util.EnumSet;
import org.apache.log4j.Logger;

public class VaultRegistryFindFeature
implements Find {
    private static final Logger log = Logger.getLogger(VaultRegistryFindFeature.class);
    private final Preferences preferences = PreferencesFactory.get();
    private final Session<?> session;
    private final Find proxy;
    private final VaultRegistry registry;
    private final VaultLookupListener lookup;
    private boolean autodetect = this.preferences.getBoolean("cryptomator.vault.autodetect") && this.preferences.getBoolean("cryptomator.enable");
    private Cache<Path> cache = PathCache.empty();

    public VaultRegistryFindFeature(Session<?> session, Find proxy, VaultRegistry registry, VaultLookupListener lookup) {
        this.session = session;
        this.proxy = proxy;
        this.registry = registry;
        this.lookup = lookup;
    }

    @Override
    public boolean find(Path file) throws BackgroundException {
        Vault vault = this.registry.find(this.session, file);
        if (vault.equals(Vault.DISABLED) && this.autodetect) {
            Path directory = file.getParent();
            Path key = new Path(directory, "masterkey.cryptomator", EnumSet.of(AbstractPath.Type.file));
            if (this.proxy.withCache(this.cache).find(key)) {
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Found master key %s", key));
                }
                try {
                    if (log.isInfoEnabled()) {
                        log.info((Object)String.format("Found vault %s", directory));
                    }
                    return this.lookup.load(this.session, directory, "masterkey.cryptomator", DefaultVaultRegistry.DEFAULT_PEPPER).getFeature(this.session, Find.class, this.proxy).withCache(this.cache).find(file);
                }
                catch (VaultUnlockCancelException vaultUnlockCancelException) {
                    // empty catch block
                }
            }
        }
        return vault.getFeature(this.session, Find.class, this.proxy).withCache(this.cache).find(file);
    }

    @Override
    public Find withCache(Cache<Path> cache) {
        this.cache = cache;
        return this;
    }

    public VaultRegistryFindFeature withAutodetect(boolean autodetect) {
        this.autodetect = autodetect && this.preferences.getBoolean("cryptomator.enable");
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VaultRegistryFindFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

