/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.shared;

import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.features.Scheduler;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.threading.BackgroundActionState;
import ch.cyberduck.core.threading.ScheduledThreadPool;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public abstract class AbstractSchedulerFeature<R, Client>
implements Scheduler<Void> {
    private static final Logger log = Logger.getLogger(AbstractSchedulerFeature.class);
    private final long period;
    private final ScheduledThreadPool scheduler = new ScheduledThreadPool();

    public AbstractSchedulerFeature(long period) {
        this.period = period;
    }

    @Override
    public Void repeat(SessionPool pool, PasswordCallback callback) {
        this.scheduler.repeat(() -> {
            try {
                Session session = pool.borrow(BackgroundActionState.running);
                try {
                    this.operate(session, callback, null);
                }
                finally {
                    pool.release(session, null);
                }
            }
            catch (ConnectionCanceledException e) {
                log.warn((Object)"Cancel processing scheduled task. %s", (Throwable)e);
                this.shutdown();
            }
            catch (BackgroundException e) {
                log.warn((Object)String.format("Failure processing scheduled task. %s", e.getMessage()), (Throwable)e);
            }
            catch (Exception e) {
                log.error((Object)String.format("Failure processing scheduled task. %s", e.getMessage()), (Throwable)e);
                this.shutdown();
            }
        }, this.period, TimeUnit.MILLISECONDS);
        return null;
    }

    protected abstract R operate(Session<Client> var1, PasswordCallback var2, Path var3) throws BackgroundException;

    @Override
    public void shutdown() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Shutting down scheduler thread pool");
        }
        this.scheduler.shutdown();
    }
}

