/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.logging;

import ch.cyberduck.core.Path;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class LoggingConfiguration {
    private final boolean enabled;
    private final String loggingTarget;
    private List<Path> containers = Collections.emptyList();

    public static LoggingConfiguration empty() {
        return new LoggingConfiguration();
    }

    public LoggingConfiguration() {
        this.enabled = false;
        this.loggingTarget = "";
    }

    public LoggingConfiguration(boolean enabled) {
        this.enabled = enabled;
        this.loggingTarget = "";
    }

    public LoggingConfiguration(boolean enabled, String loggingTarget) {
        this.enabled = enabled;
        this.loggingTarget = loggingTarget;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getLoggingTarget() {
        return this.loggingTarget;
    }

    public List<Path> getContainers() {
        return this.containers;
    }

    public void setContainers(List<Path> containers) {
        this.containers = containers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoggingConfiguration that = (LoggingConfiguration)o;
        if (this.enabled != that.enabled) {
            return false;
        }
        return Objects.equals(this.loggingTarget, that.loggingTarget);
    }

    public int hashCode() {
        int result = this.enabled ? 1 : 0;
        result = 31 * result + (this.loggingTarget != null ? this.loggingTarget.hashCode() : 0);
        return result;
    }
}

