/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.aquaticprime;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.aquaticprime.AbstractLicense;
import ch.cyberduck.core.aquaticprime.InvalidLicenseException;
import ch.cyberduck.core.aquaticprime.LicenseVerifierCallback;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.text.NaturalOrderComparator;
import com.dd.plist.NSData;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.PropertyListFormatException;
import com.dd.plist.XMLPropertyListParser;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public abstract class DictionaryLicense
extends AbstractLicense {
    private static final Logger log = Logger.getLogger(DictionaryLicense.class);
    private final Local file;
    private final NSDictionary dictionary;

    public DictionaryLicense(Local file) {
        super(file);
        this.file = file;
        this.dictionary = this.read(file);
    }

    @Override
    public boolean verify(LicenseVerifierCallback callback) {
        String publicKey = this.getPublicKey();
        try {
            this.verify(this.dictionary, publicKey);
            return true;
        }
        catch (InvalidLicenseException e) {
            callback.failure(e);
            return false;
        }
    }

    protected void verify(NSDictionary dictionary, String publicKey) throws InvalidLicenseException {
        if (null == dictionary) {
            throw new InvalidLicenseException();
        }
        NSData signature = (NSData)dictionary.objectForKey("Signature");
        if (null == signature) {
            log.warn((Object)String.format("Missing key 'Signature' in dictionary %s", dictionary));
            throw new InvalidLicenseException();
        }
        StringBuilder values = new StringBuilder();
        ArrayList keys = new ArrayList(dictionary.keySet());
        Collections.sort(keys, new NaturalOrderComparator());
        for (String key : keys) {
            if ("Signature".equals(key)) continue;
            values.append(dictionary.objectForKey(key).toString());
        }
        byte[] signaturebytes = signature.bytes();
        byte[] plainbytes = values.toString().getBytes(StandardCharsets.UTF_8);
        try {
            BigInteger modulus = new BigInteger(StringUtils.removeStart((String)publicKey, (String)"0x"), 16);
            BigInteger exponent = new BigInteger(Base64.decodeBase64((String)"Aw=="));
            RSAPublicKeySpec spec = new RSAPublicKeySpec(modulus, exponent);
            PublicKey rsa = KeyFactory.getInstance("RSA").generatePublic(spec);
            Cipher rsaCipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            rsaCipher.init(2, rsa);
            MessageDigest sha1Digest = MessageDigest.getInstance("SHA1");
            if (!Arrays.equals(rsaCipher.doFinal(signaturebytes), sha1Digest.digest(plainbytes))) {
                throw new InvalidLicenseException();
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            log.warn((Object)String.format("Signature verification failure for key %s", this.file));
            throw new InvalidLicenseException();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Valid key in %s", this.file));
        }
    }

    @Override
    public String getValue(String property) {
        if (null == this.dictionary) {
            return null;
        }
        NSObject value = this.dictionary.objectForKey(property);
        if (null == value) {
            log.warn((Object)String.format("No value for key %s in dictionary %s", property, this.dictionary));
            return null;
        }
        return value.toString();
    }

    private NSDictionary read(Local file) {
        try {
            return (NSDictionary)XMLPropertyListParser.parse((InputStream)file.getInputStream());
        }
        catch (AccessDeniedException | PropertyListFormatException | IOException | ParseException | ParserConfigurationException | SAXException e) {
            log.warn((Object)String.format("Failure %s reading dictionary from %s", e.getMessage(), file));
            return null;
        }
    }

    protected abstract String getPublicKey();
}

