/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.idna.PunycodeConverter;
import org.apache.commons.lang3.StringUtils;

public class HostUrlProvider {
    private boolean includeUsername;
    private boolean includePath;

    public HostUrlProvider() {
        this(true, false);
    }

    public HostUrlProvider(boolean includeUsername) {
        this(includeUsername, false);
    }

    public HostUrlProvider(boolean includeUsername, boolean includePath) {
        this.includeUsername = includeUsername;
        this.includePath = includePath;
    }

    public HostUrlProvider withUsername(boolean include) {
        this.includeUsername = include;
        return this;
    }

    public HostUrlProvider withPath(boolean include) {
        this.includePath = include;
        return this;
    }

    public String get(Host bookmark) {
        Scheme scheme = bookmark.getProtocol().getScheme();
        int port = bookmark.getPort();
        String username = bookmark.getCredentials().getUsername();
        String hostname = bookmark.getHostname();
        String path = bookmark.getDefaultPath();
        return this.get(scheme, port, username, hostname, path);
    }

    public String get(Scheme scheme, int port, String username, String hostname, String path) {
        String base = String.format("%s://%s%s%s", new Object[]{scheme, this.includeUsername && StringUtils.isNotEmpty((CharSequence)username) ? String.format("%s@", URIEncoder.encode(username)) : "", new PunycodeConverter().convert(hostname), port != scheme.getPort() ? String.format(":%d", port) : ""});
        if (this.includePath && StringUtils.isNotBlank((CharSequence)path)) {
            return String.format("%s%s", base, PathNormalizer.normalize(path));
        }
        return base;
    }
}

