/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.config;

import com.joyent.manta.config.ConfigContext;
import com.joyent.manta.config.DefaultsConfigContext;
import com.joyent.manta.config.EncryptionAuthenticationMode;
import com.joyent.manta.config.MetricReporterMode;
import com.joyent.manta.config.SettableConfigContext;
import java.util.Arrays;
import java.util.Objects;

public abstract class BaseChainedConfigContext
implements SettableConfigContext<BaseChainedConfigContext> {
    private volatile String mantaURL;
    private volatile String account;
    private volatile String mantaKeyId;
    private volatile String mantaKeyPath;
    private volatile String privateKeyContent;
    private volatile String password;
    private volatile Boolean noAuth;
    private volatile Boolean disableNativeSignatures;
    private volatile Boolean verifyUploads;
    private volatile Integer timeout;
    private volatile Integer retries;
    private volatile Integer maxConnections;
    private volatile Integer httpBufferSize;
    private volatile String httpsProtocols;
    private volatile String httpsCipherSuites;
    private volatile Integer tcpSocketTimeout;
    private volatile Integer connectionRequestTimeout;
    private volatile Integer expectContinueTimeout;
    private volatile Integer uploadBufferSize;
    private volatile Integer skipDirectoryDepth;
    private volatile Integer pruneEmptyParentDepth;
    private volatile Integer downloadContinuations;
    private volatile MetricReporterMode metricReporterMode;
    private volatile Integer metricReporterOutputInterval;
    private volatile Boolean clientEncryptionEnabled;
    private volatile Boolean contentTypeDetectionEnabled;
    private volatile String encryptionKeyId;
    private volatile String encryptionAlgorithm;
    private volatile Boolean permitUnencryptedDownloads;
    private volatile EncryptionAuthenticationMode encryptionAuthenticationMode;
    private volatile String encryptionPrivateKeyPath;
    private volatile byte[] encryptionPrivateKeyBytes;
    private volatile boolean mantaKeyPathSetOnlyByDefaults = false;
    public static final ConfigContext DEFAULT_CONFIG = new DefaultsConfigContext();

    public BaseChainedConfigContext() {
    }

    public BaseChainedConfigContext(ConfigContext defaultingContext) {
        this.overwriteWithContext(defaultingContext);
    }

    @Override
    public String getMantaURL() {
        return this.mantaURL;
    }

    @Override
    public String getMantaUser() {
        return this.account;
    }

    @Override
    public String getMantaKeyId() {
        return this.mantaKeyId;
    }

    @Override
    public String getMantaKeyPath() {
        return this.mantaKeyPath;
    }

    @Override
    public Integer getTimeout() {
        return this.timeout;
    }

    @Override
    public Integer getRetries() {
        return this.retries;
    }

    @Override
    public Integer getMaximumConnections() {
        return this.maxConnections;
    }

    @Override
    public String getPrivateKeyContent() {
        return this.privateKeyContent;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public Integer getHttpBufferSize() {
        return this.httpBufferSize;
    }

    @Override
    public String getHttpsProtocols() {
        return this.httpsProtocols;
    }

    @Override
    public String getHttpsCipherSuites() {
        return this.httpsCipherSuites;
    }

    @Override
    public Boolean noAuth() {
        return this.noAuth;
    }

    @Override
    public Boolean disableNativeSignatures() {
        return this.disableNativeSignatures;
    }

    @Override
    public Integer getTcpSocketTimeout() {
        return this.tcpSocketTimeout;
    }

    @Override
    public Integer getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    @Override
    public Integer getExpectContinueTimeout() {
        return this.expectContinueTimeout;
    }

    @Override
    public Boolean verifyUploads() {
        return this.verifyUploads;
    }

    @Override
    public Integer getSkipDirectoryDepth() {
        return this.skipDirectoryDepth;
    }

    @Override
    public Integer getPruneEmptyParentDepth() {
        return this.pruneEmptyParentDepth;
    }

    @Override
    public Integer downloadContinuations() {
        return this.downloadContinuations;
    }

    @Override
    public MetricReporterMode getMetricReporterMode() {
        return this.metricReporterMode;
    }

    @Override
    public Integer getMetricReporterOutputInterval() {
        return this.metricReporterOutputInterval;
    }

    @Override
    public Integer getUploadBufferSize() {
        return this.uploadBufferSize;
    }

    @Override
    public Boolean isClientEncryptionEnabled() {
        return this.clientEncryptionEnabled;
    }

    @Override
    public Boolean isContentTypeDetectionEnabled() {
        return this.contentTypeDetectionEnabled;
    }

    @Override
    public String getEncryptionKeyId() {
        return this.encryptionKeyId;
    }

    @Override
    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    @Override
    public Boolean permitUnencryptedDownloads() {
        return this.permitUnencryptedDownloads;
    }

    @Override
    public EncryptionAuthenticationMode getEncryptionAuthenticationMode() {
        return this.encryptionAuthenticationMode;
    }

    @Override
    public String getEncryptionPrivateKeyPath() {
        return this.encryptionPrivateKeyPath;
    }

    @Override
    public byte[] getEncryptionPrivateKeyBytes() {
        return this.encryptionPrivateKeyBytes;
    }

    public void overwriteWithContext(ConfigContext context) {
        boolean isDefaultContext = context.getClass().equals(DefaultsConfigContext.class);
        if (isDefaultContext) {
            this.overwriteWithDefaultContext((DefaultsConfigContext)context);
            return;
        }
        if (BaseChainedConfigContext.isPresent(context.getMantaURL())) {
            this.mantaURL = context.getMantaURL();
        }
        if (BaseChainedConfigContext.isPresent(context.getMantaUser())) {
            this.account = context.getMantaUser();
        }
        if (BaseChainedConfigContext.isPresent(context.getMantaKeyId())) {
            this.mantaKeyId = context.getMantaKeyId();
        }
        if (BaseChainedConfigContext.isPresent(context.getMantaKeyPath())) {
            if (BaseChainedConfigContext.isPresent(context.getPrivateKeyContent())) {
                String msg = "You can't set both a private key path and private key content";
                throw new IllegalArgumentException(msg);
            }
            this.mantaKeyPath = context.getMantaKeyPath();
        }
        if (context.getMetricReporterMode() != null) {
            this.metricReporterMode = context.getMetricReporterMode();
        }
        if (context.getMetricReporterOutputInterval() != null) {
            this.metricReporterOutputInterval = context.getMetricReporterOutputInterval();
        }
        if (context.getRetries() != null) {
            this.retries = context.getRetries();
        }
        if (context.getMaximumConnections() != null) {
            this.maxConnections = context.getMaximumConnections();
        }
        if (BaseChainedConfigContext.isPresent(context.getPrivateKeyContent())) {
            if (BaseChainedConfigContext.isPresent(this.mantaKeyPath) && !this.mantaKeyPathSetOnlyByDefaults) {
                String msg = "You can't set both a private key path and private key content";
                throw new IllegalArgumentException(msg);
            }
            this.privateKeyContent = context.getPrivateKeyContent();
        }
        if (BaseChainedConfigContext.isPresent(context.getPassword())) {
            this.password = context.getPassword();
        }
        if (BaseChainedConfigContext.isPresent(context.getHttpsProtocols())) {
            this.httpsProtocols = context.getHttpsProtocols();
        }
        if (BaseChainedConfigContext.isPresent(context.getHttpsCipherSuites())) {
            this.httpsCipherSuites = context.getHttpsCipherSuites();
        }
        if (context.noAuth() != null) {
            this.noAuth = context.noAuth();
        }
        if (context.disableNativeSignatures() != null) {
            this.disableNativeSignatures = context.disableNativeSignatures();
        }
        if (context.getHttpBufferSize() != null) {
            this.httpBufferSize = context.getHttpBufferSize();
        }
        this.overwriteWithContextTimeouts(context);
        if (context.verifyUploads() != null) {
            this.verifyUploads = context.verifyUploads();
        }
        if (context.getUploadBufferSize() != null) {
            this.uploadBufferSize = context.getUploadBufferSize();
        }
        if (context.getSkipDirectoryDepth() != null) {
            this.skipDirectoryDepth = context.getSkipDirectoryDepth();
        }
        if (context.getPruneEmptyParentDepth() != null) {
            this.pruneEmptyParentDepth = context.getPruneEmptyParentDepth();
        }
        if (context.downloadContinuations() != null) {
            this.downloadContinuations = context.downloadContinuations();
        }
        if (context.getMetricReporterMode() != null) {
            this.metricReporterMode = context.getMetricReporterMode();
        }
        if (context.getMetricReporterOutputInterval() != null) {
            this.metricReporterOutputInterval = context.getMetricReporterOutputInterval();
        }
        if (context.isContentTypeDetectionEnabled() != null) {
            this.contentTypeDetectionEnabled = context.isContentTypeDetectionEnabled();
        }
        this.overwriteWithContextEncryptionParams(context);
    }

    private void overwriteWithContextTimeouts(ConfigContext context) {
        boolean isDefaultContext = context.getClass().equals(DefaultsConfigContext.class);
        if (context.getTimeout() != null) {
            this.timeout = context.getTimeout();
        }
        if (context.getTcpSocketTimeout() != null) {
            this.tcpSocketTimeout = context.getTcpSocketTimeout();
        }
        if (context.getConnectionRequestTimeout() != null) {
            this.connectionRequestTimeout = context.getConnectionRequestTimeout();
        }
        if (context.getExpectContinueTimeout() != null) {
            this.expectContinueTimeout = context.getExpectContinueTimeout();
        }
    }

    private void overwriteWithContextEncryptionParams(ConfigContext context) {
        boolean isDefaultContext = context.getClass().equals(DefaultsConfigContext.class);
        if (context.isClientEncryptionEnabled() != null) {
            this.clientEncryptionEnabled = context.isClientEncryptionEnabled();
        }
        if (context.getEncryptionKeyId() != null) {
            this.encryptionKeyId = context.getEncryptionKeyId();
        }
        if (context.getEncryptionAlgorithm() != null) {
            this.encryptionAlgorithm = context.getEncryptionAlgorithm();
        }
        if (context.getEncryptionAuthenticationMode() != null) {
            this.encryptionAuthenticationMode = context.getEncryptionAuthenticationMode();
        }
        if (context.getEncryptionPrivateKeyPath() != null) {
            this.encryptionPrivateKeyPath = context.getEncryptionPrivateKeyPath();
        }
        if (context.getEncryptionPrivateKeyBytes() != null) {
            this.encryptionPrivateKeyBytes = context.getEncryptionPrivateKeyBytes();
        }
        if (context.permitUnencryptedDownloads() != null) {
            this.permitUnencryptedDownloads = context.permitUnencryptedDownloads();
        }
    }

    protected void overwriteWithDefaultContext(DefaultsConfigContext context) {
        if (!BaseChainedConfigContext.isPresent(this.getMantaURL())) {
            this.mantaURL = context.getMantaURL();
        }
        if (!BaseChainedConfigContext.isPresent(this.getMantaUser())) {
            this.account = context.getMantaUser();
        }
        if (!BaseChainedConfigContext.isPresent(this.getMantaKeyId())) {
            this.mantaKeyId = context.getMantaKeyId();
        }
        if (!BaseChainedConfigContext.isPresent(this.getMantaKeyPath()) && !BaseChainedConfigContext.isPresent(this.getPrivateKeyContent())) {
            this.mantaKeyPathSetOnlyByDefaults = true;
            this.mantaKeyPath = context.getMantaKeyPath();
        }
        if (this.getTimeout() == null) {
            this.timeout = context.getTimeout();
        }
        if (this.getRetries() == null) {
            this.retries = context.getRetries();
        }
        if (this.getMaximumConnections() == null) {
            this.maxConnections = context.getMaximumConnections();
        }
        if (!BaseChainedConfigContext.isPresent(this.getPassword())) {
            this.password = context.getPassword();
        }
        if (!BaseChainedConfigContext.isPresent(this.getHttpsProtocols())) {
            this.httpsProtocols = context.getHttpsProtocols();
        }
        if (!BaseChainedConfigContext.isPresent(this.getHttpsCipherSuites())) {
            this.httpsCipherSuites = context.getHttpsCipherSuites();
        }
        if (this.noAuth() == null) {
            this.noAuth = context.noAuth();
        }
        if (this.disableNativeSignatures() == null) {
            this.disableNativeSignatures = context.disableNativeSignatures();
        }
        if (this.httpBufferSize == null) {
            this.httpBufferSize = context.getHttpBufferSize();
        }
        if (this.tcpSocketTimeout == null) {
            this.tcpSocketTimeout = context.getTcpSocketTimeout();
        }
        if (this.connectionRequestTimeout == null) {
            this.connectionRequestTimeout = context.getConnectionRequestTimeout();
        }
        if (this.expectContinueTimeout == null) {
            this.expectContinueTimeout = context.getExpectContinueTimeout();
        }
        if (this.verifyUploads == null) {
            this.verifyUploads = context.verifyUploads();
        }
        if (this.uploadBufferSize == null) {
            this.uploadBufferSize = context.getUploadBufferSize();
        }
        if (this.skipDirectoryDepth == null) {
            this.skipDirectoryDepth = context.getSkipDirectoryDepth();
        }
        if (this.pruneEmptyParentDepth == null) {
            this.pruneEmptyParentDepth = context.getPruneEmptyParentDepth();
        }
        if (this.downloadContinuations == null) {
            this.downloadContinuations = context.downloadContinuations();
        }
        if (this.getMetricReporterMode() == null) {
            this.metricReporterMode = context.getMetricReporterMode();
        }
        if (this.getMetricReporterOutputInterval() == null) {
            this.metricReporterOutputInterval = context.getMetricReporterOutputInterval();
        }
        if (this.clientEncryptionEnabled == null) {
            this.clientEncryptionEnabled = context.isClientEncryptionEnabled();
        }
        if (this.contentTypeDetectionEnabled == null) {
            this.contentTypeDetectionEnabled = context.isContentTypeDetectionEnabled();
        }
        if (this.encryptionKeyId == null) {
            this.encryptionKeyId = context.getEncryptionKeyId();
        }
        if (this.encryptionAlgorithm == null) {
            this.encryptionAlgorithm = context.getEncryptionAlgorithm();
        }
        if (this.encryptionAuthenticationMode == null) {
            this.encryptionAuthenticationMode = context.getEncryptionAuthenticationMode();
        }
        if (this.encryptionPrivateKeyPath == null) {
            this.encryptionPrivateKeyPath = context.getEncryptionPrivateKeyPath();
        }
        if (this.permitUnencryptedDownloads == null) {
            this.permitUnencryptedDownloads = context.permitUnencryptedDownloads();
        }
    }

    protected static boolean isPresent(String string) {
        return string != null && !string.isEmpty();
    }

    @Override
    public BaseChainedConfigContext setMantaURL(String mantaURL) {
        this.mantaURL = mantaURL;
        return this;
    }

    @Override
    public BaseChainedConfigContext setMantaUser(String mantaUser) {
        this.account = mantaUser;
        return this;
    }

    @Override
    public BaseChainedConfigContext setMantaKeyId(String mantaKeyId) {
        this.mantaKeyId = mantaKeyId;
        return this;
    }

    @Override
    public BaseChainedConfigContext setMantaKeyPath(String mantaKeyPath) {
        if (BaseChainedConfigContext.isPresent(this.privateKeyContent)) {
            String msg = "You can't set both a private key path and private key content";
            throw new IllegalArgumentException(msg);
        }
        this.mantaKeyPath = mantaKeyPath;
        return this;
    }

    @Override
    public BaseChainedConfigContext setTimeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    @Override
    public BaseChainedConfigContext setRetries(Integer retries) {
        if (retries < 0) {
            throw new IllegalArgumentException("Retries must be zero or greater");
        }
        this.retries = retries;
        return this;
    }

    @Override
    public BaseChainedConfigContext setMaximumConnections(Integer maxConns) {
        if (maxConns < 1) {
            throw new IllegalArgumentException("Maximum number of connections must be 1 or greater");
        }
        this.maxConnections = maxConns;
        return this;
    }

    @Override
    public BaseChainedConfigContext setPrivateKeyContent(String privateKeyContent) {
        if (BaseChainedConfigContext.isPresent(this.mantaKeyPath)) {
            String msg = "You can't set both a private key path and private key content";
            throw new IllegalArgumentException(msg);
        }
        this.privateKeyContent = privateKeyContent;
        return this;
    }

    @Override
    public BaseChainedConfigContext setPassword(String password) {
        this.password = password;
        return this;
    }

    @Override
    public BaseChainedConfigContext setHttpBufferSize(Integer httpBufferSize) {
        this.httpBufferSize = httpBufferSize;
        return this;
    }

    @Override
    public BaseChainedConfigContext setHttpsProtocols(String httpsProtocols) {
        this.httpsProtocols = httpsProtocols;
        return this;
    }

    @Override
    public BaseChainedConfigContext setHttpsCipherSuites(String httpsCipherSuites) {
        this.httpsCipherSuites = httpsCipherSuites;
        return this;
    }

    @Override
    public BaseChainedConfigContext setNoAuth(Boolean noAuth) {
        this.noAuth = noAuth;
        return this;
    }

    @Override
    public BaseChainedConfigContext setDisableNativeSignatures(Boolean disableNativeSignatures) {
        this.disableNativeSignatures = disableNativeSignatures;
        return this;
    }

    @Override
    public BaseChainedConfigContext setTcpSocketTimeout(Integer tcpSocketTimeout) {
        this.tcpSocketTimeout = tcpSocketTimeout;
        return this;
    }

    @Override
    public BaseChainedConfigContext setConnectionRequestTimeout(Integer connectionRequestTimeout) {
        this.connectionRequestTimeout = connectionRequestTimeout;
        return this;
    }

    @Override
    public BaseChainedConfigContext setExpectContinueTimeout(Integer expectContinueTimeout) {
        this.expectContinueTimeout = expectContinueTimeout;
        return this;
    }

    @Override
    public BaseChainedConfigContext setVerifyUploads(Boolean verify) {
        this.verifyUploads = verify;
        return this;
    }

    @Override
    public BaseChainedConfigContext setUploadBufferSize(Integer size) {
        this.uploadBufferSize = size;
        return this;
    }

    @Override
    public BaseChainedConfigContext setSkipDirectoryDepth(Integer depth) {
        this.skipDirectoryDepth = depth;
        return this;
    }

    @Override
    public BaseChainedConfigContext setPruneEmptyParentDepth(Integer depth) {
        this.pruneEmptyParentDepth = depth;
        return this;
    }

    @Override
    public BaseChainedConfigContext setDownloadContinuations(Integer continuation) {
        this.downloadContinuations = continuation;
        return this;
    }

    @Override
    public BaseChainedConfigContext setMetricReporterMode(MetricReporterMode metricReporterMode) {
        this.metricReporterMode = metricReporterMode;
        return this;
    }

    @Override
    public BaseChainedConfigContext setMetricReporterOutputInterval(Integer metricReporterOutputInterval) {
        this.metricReporterOutputInterval = metricReporterOutputInterval;
        return this;
    }

    @Override
    public BaseChainedConfigContext setClientEncryptionEnabled(Boolean clientEncryptionEnabled) {
        this.clientEncryptionEnabled = clientEncryptionEnabled;
        return this;
    }

    @Override
    public BaseChainedConfigContext setContentTypeDetectionEnabled(Boolean contentTypeDetectionEnabled) {
        this.contentTypeDetectionEnabled = contentTypeDetectionEnabled;
        return this;
    }

    @Override
    public BaseChainedConfigContext setEncryptionKeyId(String keyId) {
        this.encryptionKeyId = keyId;
        return this;
    }

    @Override
    public BaseChainedConfigContext setEncryptionAlgorithm(String algorithm) {
        this.encryptionAlgorithm = algorithm;
        return this;
    }

    @Override
    public BaseChainedConfigContext setPermitUnencryptedDownloads(Boolean permitUnencryptedDownloads) {
        this.permitUnencryptedDownloads = permitUnencryptedDownloads;
        return this;
    }

    @Override
    public BaseChainedConfigContext setEncryptionAuthenticationMode(EncryptionAuthenticationMode encryptionAuthenticationMode) {
        this.encryptionAuthenticationMode = encryptionAuthenticationMode;
        return this;
    }

    @Override
    public BaseChainedConfigContext setEncryptionPrivateKeyPath(String encryptionPrivateKeyPath) {
        if (this.encryptionPrivateKeyBytes != null) {
            String msg = "You can't set both encryption key content and a private encryption key path";
            throw new IllegalArgumentException(msg);
        }
        this.encryptionPrivateKeyPath = encryptionPrivateKeyPath;
        return this;
    }

    @Override
    public BaseChainedConfigContext setEncryptionPrivateKeyBytes(byte[] encryptionPrivateKeyBytes) {
        if (BaseChainedConfigContext.isPresent(this.encryptionPrivateKeyPath)) {
            String msg = "You can't set both a private encryption key path and encryption key content";
            throw new IllegalArgumentException(msg);
        }
        this.encryptionPrivateKeyBytes = encryptionPrivateKeyBytes;
        return this;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BaseChainedConfigContext)) {
            return false;
        }
        BaseChainedConfigContext that = (BaseChainedConfigContext)other;
        return Objects.equals(this.mantaURL, that.mantaURL) && Objects.equals(this.account, that.account) && Objects.equals(this.mantaKeyId, that.mantaKeyId) && Objects.equals(this.mantaKeyPath, that.mantaKeyPath) && Objects.equals(this.timeout, that.timeout) && Objects.equals(this.retries, that.retries) && Objects.equals(this.maxConnections, that.maxConnections) && Objects.equals(this.privateKeyContent, that.privateKeyContent) && Objects.equals(this.password, that.password) && Objects.equals(this.httpBufferSize, that.httpBufferSize) && Objects.equals(this.httpsProtocols, that.httpsProtocols) && Objects.equals(this.httpsCipherSuites, that.httpsCipherSuites) && Objects.equals(this.noAuth, that.noAuth) && Objects.equals(this.disableNativeSignatures, that.disableNativeSignatures) && Objects.equals(this.tcpSocketTimeout, that.tcpSocketTimeout) && Objects.equals(this.connectionRequestTimeout, that.connectionRequestTimeout) && Objects.equals(this.expectContinueTimeout, that.expectContinueTimeout) && Objects.equals(this.verifyUploads, that.verifyUploads) && Objects.equals(this.uploadBufferSize, that.uploadBufferSize) && Objects.equals(this.skipDirectoryDepth, that.skipDirectoryDepth) && Objects.equals(this.pruneEmptyParentDepth, that.pruneEmptyParentDepth) && Objects.equals(this.downloadContinuations, that.downloadContinuations) && Objects.equals((Object)this.metricReporterMode, (Object)that.metricReporterMode) && Objects.equals(this.metricReporterOutputInterval, that.metricReporterOutputInterval) && Objects.equals(this.clientEncryptionEnabled, that.clientEncryptionEnabled) && Objects.equals(this.contentTypeDetectionEnabled, that.contentTypeDetectionEnabled) && Objects.equals(this.encryptionKeyId, that.encryptionKeyId) && Objects.equals(this.encryptionAlgorithm, that.encryptionAlgorithm) && Objects.equals(this.permitUnencryptedDownloads, that.permitUnencryptedDownloads) && Objects.equals((Object)this.encryptionAuthenticationMode, (Object)that.encryptionAuthenticationMode) && Objects.equals(this.encryptionPrivateKeyPath, that.encryptionPrivateKeyPath) && Arrays.equals(this.encryptionPrivateKeyBytes, that.encryptionPrivateKeyBytes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mantaURL, this.account, this.mantaKeyId, this.mantaKeyPath, this.timeout, this.retries, this.maxConnections, this.privateKeyContent, this.password, this.httpBufferSize, this.httpsProtocols, this.httpsCipherSuites, this.noAuth, this.disableNativeSignatures, this.tcpSocketTimeout, this.connectionRequestTimeout, this.expectContinueTimeout, this.verifyUploads, this.uploadBufferSize, this.skipDirectoryDepth, this.downloadContinuations, this.metricReporterMode, this.metricReporterOutputInterval, this.clientEncryptionEnabled, this.encryptionKeyId, this.contentTypeDetectionEnabled, this.encryptionAlgorithm, this.permitUnencryptedDownloads, this.encryptionAuthenticationMode, this.encryptionPrivateKeyPath, Arrays.hashCode(this.encryptionPrivateKeyBytes)});
    }

    public String toString() {
        return ConfigContext.toString(this);
    }
}

