/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.config;

import com.joyent.http.signature.Signer;
import com.joyent.http.signature.ThreadLocalSigner;
import com.joyent.http.signature.apache.httpclient.HttpSignatureAuthScheme;
import com.joyent.manta.config.ConfigContext;
import com.joyent.manta.config.EncryptionAuthenticationMode;
import com.joyent.manta.config.KeyPairFactory;
import com.joyent.manta.config.MetricReporterMode;
import com.joyent.manta.config.StandardConfigContext;
import java.security.KeyPair;
import java.util.Objects;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;

public class AuthAwareConfigContext
extends StandardConfigContext
implements AutoCloseable {
    private final Object lock = new Object();
    private volatile AuthContext authContext;

    public AuthAwareConfigContext() {
        this(null);
    }

    public AuthAwareConfigContext(ConfigContext config) {
        if (config != null) {
            this.overwriteWithContext(config);
        }
        this.reload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthAwareConfigContext reload() {
        Object object = this.lock;
        synchronized (object) {
            int newParamsFingerprint = AuthAwareConfigContext.calculateAuthParamsFingerprint(this);
            if (this.authContext != null) {
                if (this.authContext.paramsFingerprint == newParamsFingerprint) {
                    return this;
                }
                this.authContext.signer.clearAll();
                this.authContext = null;
            }
            if (BooleanUtils.isNotTrue((Boolean)this.noAuth())) {
                this.authContext = this.doLoad(newParamsFingerprint);
            }
        }
        return this;
    }

    private AuthContext doLoad(int paramsFingerprint) {
        if (BooleanUtils.isNotFalse((Boolean)this.noAuth())) {
            return null;
        }
        KeyPair keyPair = new KeyPairFactory(this).createKeyPair();
        Signer.Builder builder = new Signer.Builder(keyPair);
        if (BooleanUtils.isTrue((Boolean)this.disableNativeSignatures())) {
            builder.providerCode("stdlib");
        }
        ThreadLocalSigner signer = new ThreadLocalSigner(builder);
        return new AuthContext(paramsFingerprint, keyPair, signer, (Credentials)new UsernamePasswordCredentials(this.getMantaUser(), null), new HttpSignatureAuthScheme(keyPair, signer));
    }

    public Credentials getCredentials() {
        if (this.authContext == null) {
            return null;
        }
        return this.authContext.credentials;
    }

    public HttpSignatureAuthScheme getAuthScheme() {
        if (this.authContext == null) {
            return null;
        }
        return this.authContext.authScheme;
    }

    public KeyPair getKeyPair() {
        if (this.authContext == null) {
            return null;
        }
        return this.authContext.keyPair;
    }

    public ThreadLocalSigner getSigner() {
        if (this.authContext == null) {
            return null;
        }
        return this.authContext.signer;
    }

    private static int calculateAuthParamsFingerprint(ConfigContext config) {
        return Objects.hash(config.noAuth(), config.disableNativeSignatures(), config.getMantaUser(), config.getPassword(), config.getMantaKeyId(), config.getMantaKeyPath(), config.getPrivateKeyContent());
    }

    @Override
    public void close() {
        if (this.authContext != null) {
            this.authContext.signer.clearAll();
        }
        this.authContext = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthAwareConfigContext setMantaURL(String mantaURL) {
        Object object = this.lock;
        synchronized (object) {
            super.setMantaURL(mantaURL);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthAwareConfigContext setMantaUser(String mantaUser) {
        Object object = this.lock;
        synchronized (object) {
            super.setMantaUser(mantaUser);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthAwareConfigContext setMantaKeyId(String mantaKeyId) {
        Object object = this.lock;
        synchronized (object) {
            super.setMantaKeyId(mantaKeyId);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthAwareConfigContext setMantaKeyPath(String mantaKeyPath) {
        Object object = this.lock;
        synchronized (object) {
            super.setMantaKeyPath(mantaKeyPath);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthAwareConfigContext setTimeout(Integer timeout) {
        Object object = this.lock;
        synchronized (object) {
            super.setTimeout(timeout);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthAwareConfigContext setRetries(Integer retries) {
        Object object = this.lock;
        synchronized (object) {
            super.setRetries(retries);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthAwareConfigContext setMaximumConnections(Integer maxConns) {
        Object object = this.lock;
        synchronized (object) {
            super.setMaximumConnections(maxConns);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthAwareConfigContext setPrivateKeyContent(String privateKeyContent) {
        Object object = this.lock;
        synchronized (object) {
            super.setPrivateKeyContent(privateKeyContent);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthAwareConfigContext setPassword(String password) {
        Object object = this.lock;
        synchronized (object) {
            super.setPassword(password);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthAwareConfigContext setHttpBufferSize(Integer httpBufferSize) {
        Object object = this.lock;
        synchronized (object) {
            super.setHttpBufferSize(httpBufferSize);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthAwareConfigContext setHttpsProtocols(String httpsProtocols) {
        Object object = this.lock;
        synchronized (object) {
            super.setHttpsProtocols(httpsProtocols);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthAwareConfigContext setHttpsCipherSuites(String httpsCipherSuites) {
        Object object = this.lock;
        synchronized (object) {
            super.setHttpsCipherSuites(httpsCipherSuites);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthAwareConfigContext setNoAuth(Boolean noAuth) {
        Object object = this.lock;
        synchronized (object) {
            super.setNoAuth(noAuth);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthAwareConfigContext setDisableNativeSignatures(Boolean disableNativeSignatures) {
        Object object = this.lock;
        synchronized (object) {
            super.setDisableNativeSignatures(disableNativeSignatures);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthAwareConfigContext setTcpSocketTimeout(Integer tcpSocketTimeout) {
        Object object = this.lock;
        synchronized (object) {
            super.setTcpSocketTimeout(tcpSocketTimeout);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthAwareConfigContext setConnectionRequestTimeout(Integer connectionRequestTimeout) {
        Object object = this.lock;
        synchronized (object) {
            super.setConnectionRequestTimeout(connectionRequestTimeout);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthAwareConfigContext setVerifyUploads(Boolean verify) {
        Object object = this.lock;
        synchronized (object) {
            super.setVerifyUploads(verify);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthAwareConfigContext setUploadBufferSize(Integer size) {
        Object object = this.lock;
        synchronized (object) {
            super.setUploadBufferSize(size);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthAwareConfigContext setMetricReporterMode(MetricReporterMode metricReporterMode) {
        Object object = this.lock;
        synchronized (object) {
            super.setMetricReporterMode(metricReporterMode);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthAwareConfigContext setMetricReporterOutputInterval(Integer metricReporterOutputInterval) {
        Object object = this.lock;
        synchronized (object) {
            super.setMetricReporterOutputInterval(metricReporterOutputInterval);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthAwareConfigContext setClientEncryptionEnabled(Boolean clientEncryptionEnabled) {
        Object object = this.lock;
        synchronized (object) {
            super.setClientEncryptionEnabled(clientEncryptionEnabled);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthAwareConfigContext setEncryptionKeyId(String keyId) {
        Object object = this.lock;
        synchronized (object) {
            super.setEncryptionKeyId(keyId);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthAwareConfigContext setEncryptionAlgorithm(String algorithm) {
        Object object = this.lock;
        synchronized (object) {
            super.setEncryptionAlgorithm(algorithm);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthAwareConfigContext setPermitUnencryptedDownloads(Boolean permitUnencryptedDownloads) {
        Object object = this.lock;
        synchronized (object) {
            super.setPermitUnencryptedDownloads(permitUnencryptedDownloads);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthAwareConfigContext setEncryptionAuthenticationMode(EncryptionAuthenticationMode encryptionAuthenticationMode) {
        Object object = this.lock;
        synchronized (object) {
            super.setEncryptionAuthenticationMode(encryptionAuthenticationMode);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthAwareConfigContext setEncryptionPrivateKeyPath(String encryptionPrivateKeyPath) {
        Object object = this.lock;
        synchronized (object) {
            super.setEncryptionPrivateKeyPath(encryptionPrivateKeyPath);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthAwareConfigContext setEncryptionPrivateKeyBytes(byte[] encryptionPrivateKeyBytes) {
        Object object = this.lock;
        synchronized (object) {
            super.setEncryptionPrivateKeyBytes(encryptionPrivateKeyBytes);
        }
        return this;
    }

    private static final class AuthContext {
        private final int paramsFingerprint;
        private final KeyPair keyPair;
        private final ThreadLocalSigner signer;
        private final Credentials credentials;
        private final HttpSignatureAuthScheme authScheme;

        private AuthContext(int paramsFingerprint, KeyPair keyPair, ThreadLocalSigner signer, Credentials credentials, HttpSignatureAuthScheme authScheme) {
            this.paramsFingerprint = paramsFingerprint;
            this.keyPair = keyPair;
            this.signer = signer;
            this.credentials = credentials;
            this.authScheme = authScheme;
        }
    }
}

