/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client.jobs;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.joyent.manta.client.jobs.MantaJobPhase;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MantaJob {
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private UUID id;
    private String name;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private String state;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private Boolean cancelled;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private Boolean inputDone;
    @JsonProperty(value="transient", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean tranzient;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private Map<String, Number> stats;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private Instant timeCreated;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private Instant timeDone;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private Instant timeArchiveStarted;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private Instant timeArchiveDone;
    private List<MantaJobPhase> phases;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private Map<String, Object> options;

    MantaJob() {
    }

    public MantaJob(String name, List<MantaJobPhase> phases) {
        this.name = name;
        this.phases = phases;
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getState() {
        return this.state;
    }

    public Boolean getTransient() {
        return this.tranzient;
    }

    public Map<String, Number> getStats() {
        return this.stats;
    }

    public Instant getTimeArchiveStarted() {
        return this.timeArchiveStarted;
    }

    public Instant getTimeArchiveDone() {
        return this.timeArchiveDone;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public Boolean getCancelled() {
        return this.cancelled;
    }

    public Boolean getInputDone() {
        return this.inputDone;
    }

    public Instant getTimeCreated() {
        return this.timeCreated;
    }

    public Instant getTimeDone() {
        return this.timeDone;
    }

    public List<MantaJobPhase> getPhases() {
        return this.phases;
    }

    @JsonIgnore
    public List<MantaJobPhase> getMapPhases() {
        try (Stream<MantaJobPhase> stream = this.phases.stream().filter(p -> p.getType().equals("map"));){
            List list = stream.collect(Collectors.toCollection(ArrayList::new));
            return list;
        }
    }

    @JsonIgnore
    public List<MantaJobPhase> getReducePhases() {
        try (Stream<MantaJobPhase> stream = this.phases.stream().filter(p -> p.getType().equals("reduce"));){
            List list = stream.collect(Collectors.toCollection(ArrayList::new));
            return list;
        }
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof MantaJob)) {
            return false;
        }
        MantaJob mantaJob = (MantaJob)that;
        return Objects.equals(this.id, mantaJob.id) && Objects.equals(this.name, mantaJob.name) && Objects.equals(this.state, mantaJob.state) && Objects.equals(this.cancelled, mantaJob.cancelled) && Objects.equals(this.inputDone, mantaJob.inputDone) && Objects.equals(this.timeCreated, mantaJob.timeCreated) && Objects.equals(this.timeDone, mantaJob.timeDone) && Objects.equals(this.phases, mantaJob.phases);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.state, this.cancelled, this.inputDone, this.timeCreated, this.timeDone, this.phases);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MantaJob{");
        sb.append("id=").append(this.id);
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", state='").append(this.state).append('\'');
        sb.append(", cancelled=").append(this.cancelled);
        sb.append(", inputDone=").append(this.inputDone);
        sb.append(", timeCreated=").append(this.timeCreated);
        sb.append(", timeDone=").append(this.timeDone);
        sb.append(", phases=").append(this.phases);
        sb.append('}');
        return sb.toString();
    }
}

