/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class S3Config {
    @JsonProperty(value="endpointUrl")
    private String endpointUrl = null;
    @JsonProperty(value="bucketName")
    private String bucketName = null;
    @JsonProperty(value="accessKeyDefined")
    private Boolean accessKeyDefined = null;
    @JsonProperty(value="secretKeyDefined")
    private Boolean secretKeyDefined = null;
    @JsonProperty(value="region")
    private String region = null;

    public S3Config endpointUrl(String endpointUrl) {
        this.endpointUrl = endpointUrl;
        return this;
    }

    @ApiModelProperty(example="https://www.random-url.com", required=true, value="S3 object storage endpoint URL")
    public String getEndpointUrl() {
        return this.endpointUrl;
    }

    public void setEndpointUrl(String endpointUrl) {
        this.endpointUrl = endpointUrl;
    }

    public S3Config bucketName(String bucketName) {
        this.bucketName = bucketName;
        return this;
    }

    @ApiModelProperty(required=true, value="S3 bucket name")
    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public S3Config accessKeyDefined(Boolean accessKeyDefined) {
        this.accessKeyDefined = accessKeyDefined;
        return this;
    }

    @ApiModelProperty(example="false", required=true, value="Determines whether Access Key ID is defined")
    public Boolean getAccessKeyDefined() {
        return this.accessKeyDefined;
    }

    public void setAccessKeyDefined(Boolean accessKeyDefined) {
        this.accessKeyDefined = accessKeyDefined;
    }

    public S3Config secretKeyDefined(Boolean secretKeyDefined) {
        this.secretKeyDefined = secretKeyDefined;
        return this;
    }

    @ApiModelProperty(example="false", required=true, value="Determines whether Access Secret Key is defined")
    public Boolean getSecretKeyDefined() {
        return this.secretKeyDefined;
    }

    public void setSecretKeyDefined(Boolean secretKeyDefined) {
        this.secretKeyDefined = secretKeyDefined;
    }

    public S3Config region(String region) {
        this.region = region;
        return this;
    }

    @ApiModelProperty(value="S3 region")
    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        S3Config s3Config = (S3Config)o;
        return Objects.equals(this.endpointUrl, s3Config.endpointUrl) && Objects.equals(this.bucketName, s3Config.bucketName) && Objects.equals(this.accessKeyDefined, s3Config.accessKeyDefined) && Objects.equals(this.secretKeyDefined, s3Config.secretKeyDefined) && Objects.equals(this.region, s3Config.region);
    }

    public int hashCode() {
        return Objects.hash(this.endpointUrl, this.bucketName, this.accessKeyDefined, this.secretKeyDefined, this.region);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class S3Config {\n");
        sb.append("    endpointUrl: ").append(this.toIndentedString(this.endpointUrl)).append("\n");
        sb.append("    bucketName: ").append(this.toIndentedString(this.bucketName)).append("\n");
        sb.append("    accessKeyDefined: ").append(this.toIndentedString(this.accessKeyDefined)).append("\n");
        sb.append("    secretKeyDefined: ").append(this.toIndentedString(this.secretKeyDefined)).append("\n");
        sb.append("    region: ").append(this.toIndentedString(this.region)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

