/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.sds.SDSAttributesFinderFeature;
import ch.cyberduck.core.sds.SDSExceptionMappingService;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.api.NodesApi;
import ch.cyberduck.core.sds.io.swagger.client.model.Node;
import ch.cyberduck.core.sds.io.swagger.client.model.NodeList;
import java.util.EnumSet;

public class SDSListService
implements ListService {
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;

    public SDSListService(SDSSession session, SDSNodeIdProvider nodeid) {
        this.session = session;
        this.nodeid = nodeid;
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        return this.list(directory, listener, PreferencesFactory.get().getInteger("sds.listing.chunksize"));
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener, int chunksize) throws BackgroundException {
        AttributedList children = new AttributedList();
        try {
            NodeList nodes;
            Integer offset = 0;
            SDSAttributesFinderFeature feature = new SDSAttributesFinderFeature(this.session, this.nodeid);
            do {
                nodes = new NodesApi((ApiClient)this.session.getClient()).getFsNodes(0, Long.parseLong(this.nodeid.getFileid(directory, (ListProgressListener)new DisabledListProgressListener())), null, null, "name:asc", offset, chunksize, "", null);
                for (Node node : nodes.getItems()) {
                    PathAttributes attributes = feature.toAttributes(node);
                    EnumSet<AbstractPath.Type> type = feature.toType(node);
                    Path file = new Path(directory, node.getName(), type, attributes);
                    children.add((Referenceable)file);
                    listener.chunk(directory, children);
                }
                offset = offset + chunksize;
            } while (nodes.getItems().size() == chunksize);
        }
        catch (ApiException e) {
            throw new SDSExceptionMappingService().map("Listing directory {0} failed", e, directory);
        }
        return children;
    }

    public ListService withCache(Cache<Path> cache) {
        this.nodeid.withCache((Cache)cache);
        return this;
    }
}

