/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.urlhandler;

import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.library.Native;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.local.ApplicationFinder;
import ch.cyberduck.core.local.ApplicationFinderFactory;
import ch.cyberduck.core.urlhandler.AbstractSchemeHandler;
import java.util.ArrayList;
import java.util.List;

public final class LaunchServicesSchemeHandler
extends AbstractSchemeHandler {
    private ApplicationFinder applicationFinder;

    public LaunchServicesSchemeHandler() {
        this(ApplicationFinderFactory.get());
    }

    public LaunchServicesSchemeHandler(ApplicationFinder applicationFinder) {
        this.applicationFinder = applicationFinder;
    }

    public void setDefaultHandlerForScheme(Application application, String scheme) {
        this.setDefaultHandler(scheme, application.getIdentifier());
    }

    private native void setDefaultHandler(String var1, String var2);

    public Application getDefaultHandler(Scheme scheme) {
        Application application = this.applicationFinder.getDescription(this.getDefaultHandler(scheme.name()));
        if (this.applicationFinder.isInstalled(application)) {
            return application;
        }
        return Application.notfound;
    }

    private native String getDefaultHandler(String var1);

    public List<Application> getAllHandlers(Scheme scheme) {
        ArrayList<Application> handlers = new ArrayList<Application>();
        for (String bundleIdentifier : this.getAllHandlers(scheme.name())) {
            Application application = this.applicationFinder.getDescription(bundleIdentifier);
            if (!this.applicationFinder.isInstalled(application)) continue;
            handlers.add(application);
        }
        return handlers;
    }

    private native String[] getAllHandlers(String var1);

    static {
        Native.load((String)"core");
    }
}

