/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.transfer;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Serializable;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.UUIDRandomStringService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.serializer.Serializer;
import ch.cyberduck.core.shared.DefaultUrlProvider;
import ch.cyberduck.core.transfer.TransferAction;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.core.transfer.TransferOptions;
import ch.cyberduck.core.transfer.TransferPathFilter;
import ch.cyberduck.core.transfer.TransferPrompt;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;

public abstract class Transfer
implements Serializable {
    private static final Logger log = Logger.getLogger(Transfer.class);
    protected final List<TransferItem> roots = new ArrayList<TransferItem>();
    private AtomicLong size;
    private AtomicLong transferred;
    private final Map<Local, Object> locks = new HashMap<Local, Object>();
    protected final Host host;
    protected BandwidthThrottle bandwidth = new BandwidthThrottle(-1.0f);
    private boolean reset;
    protected Date timestamp;
    protected String uuid = new UUIDRandomStringService().random();
    private State state = State.stopped;

    public abstract Type getType();

    public boolean isRunning() {
        return this.state == State.running;
    }

    public Transfer(Host host, Path root, Local folder, BandwidthThrottle bandwidth) {
        this(host, Collections.singletonList(new TransferItem(root, folder)), bandwidth);
    }

    public Transfer(Host host, List<TransferItem> roots, BandwidthThrottle bandwidth) {
        this.host = host;
        this.roots.addAll(roots);
        this.bandwidth = bandwidth;
    }

    public abstract Transfer withCache(Cache<Path> var1);

    @Override
    public <T> T serialize(Serializer dict) {
        dict.setStringForKey(this.getType().name(), "Type");
        dict.setObjectForKey(this.host, "Host");
        dict.setListForKey(this.roots, "Items");
        dict.setStringForKey(this.uuid, "UUID");
        if (this.size != null) {
            dict.setStringForKey(String.valueOf(this.size), "Size");
        }
        if (this.transferred != null) {
            dict.setStringForKey(String.valueOf(this.transferred), "Current");
        }
        if (this.timestamp != null) {
            dict.setStringForKey(String.valueOf(this.timestamp.getTime()), "Timestamp");
        }
        if (this.bandwidth != null) {
            dict.setStringForKey(String.valueOf(this.bandwidth.getRate()), "Bandwidth");
        }
        return dict.getSerialized();
    }

    public void setBandwidth(float bytesPerSecond) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Throttle bandwidth to %s bytes per second", Float.valueOf(bytesPerSecond)));
        }
        this.bandwidth.setRate(bytesPerSecond);
    }

    public void setBandwidth(BandwidthThrottle bandwidth) {
        this.bandwidth = bandwidth;
    }

    public BandwidthThrottle getBandwidth() {
        return this.bandwidth;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public TransferItem getRoot() {
        return this.roots.iterator().next();
    }

    public DescriptiveUrl getRemote() {
        if (this.roots.size() == 1) {
            return new DefaultUrlProvider(this.host).toUrl(this.getRoot().remote).find(DescriptiveUrl.Type.provider);
        }
        return new DefaultUrlProvider(this.host).toUrl(this.getRoot().remote.getParent()).find(DescriptiveUrl.Type.provider);
    }

    public String getLocal() {
        Local local = this.roots.iterator().next().local;
        if (this.roots.size() == 1) {
            return local.getAbbreviatedPath();
        }
        return local.getParent().getAbbreviatedPath();
    }

    public List<TransferItem> getRoots() {
        return this.roots;
    }

    public Host getSource() {
        return this.host;
    }

    public Host getDestination() {
        return null;
    }

    public Host.TransferType getTransferType() {
        if (Host.TransferType.unknown.equals((Object)this.host.getTransferType())) {
            return Host.TransferType.valueOf(PreferencesFactory.get().getProperty("queue.transfer.type"));
        }
        return this.host.getTransferType();
    }

    public String getName() {
        if (this.roots.isEmpty()) {
            return LocaleFactory.localizedString("None");
        }
        StringBuilder name = new StringBuilder();
        name.append(this.roots.iterator().next().remote.getName());
        if (this.roots.size() > 1) {
            name.append("\u2026 (").append(this.roots.size()).append(")");
        }
        return name.toString();
    }

    public abstract TransferPathFilter filter(Session<?> var1, Session<?> var2, TransferAction var3, ProgressListener var4);

    public abstract TransferAction action(Session<?> var1, Session<?> var2, boolean var3, boolean var4, TransferPrompt var5, ListProgressListener var6) throws BackgroundException;

    public abstract List<TransferItem> list(Session<?> var1, Path var2, Local var3, ListProgressListener var4) throws BackgroundException;

    public void pre(Session<?> source, Session<?> destination, Map<TransferItem, TransferStatus> files, ConnectionCallback callback) throws BackgroundException {
        for (TransferItem item : this.roots) {
            switch (this.getType()) {
                case download: {
                    Local directory = item.local.getParent();
                    this.locks.put(directory, directory.lock(true));
                    break;
                }
                case upload: {
                    this.locks.put(item.local, item.local.lock(true));
                }
            }
        }
    }

    public void post(Session<?> source, Session<?> destination, Map<TransferItem, TransferStatus> files, ConnectionCallback callback) throws BackgroundException {
        Iterator<Map.Entry<Local, Object>> iter = this.locks.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Local, Object> entry = iter.next();
            switch (this.getType()) {
                case download: {
                    Local directory = entry.getKey().getParent();
                    directory.release(entry.getValue());
                    break;
                }
                case upload: {
                    entry.getKey().release(entry.getValue());
                }
            }
            iter.remove();
        }
    }

    public abstract Path transfer(Session<?> var1, Session<?> var2, Path var3, Local var4, TransferOptions var5, TransferStatus var6, ConnectionCallback var7, ProgressListener var8, StreamListener var9) throws BackgroundException;

    public void start() {
        this.state = State.running;
        this.reset = false;
    }

    public abstract void normalize();

    public void stop() {
        this.state = State.stopped;
        this.timestamp = new Date();
    }

    public synchronized void reset() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Reset status for %s", this));
        }
        this.transferred = null;
        this.size = null;
        this.reset = true;
    }

    public boolean isReset() {
        return this.reset;
    }

    public synchronized boolean isComplete() {
        if (null == this.size || null == this.transferred) {
            return false;
        }
        return Objects.equals(this.getSize(), this.getTransferred());
    }

    public Long getSize() {
        if (null == this.size) {
            return 0L;
        }
        return this.size.get();
    }

    public void addSize(long bytes) {
        if (null == this.size) {
            this.size = new AtomicLong(0L);
        }
        if (bytes > 0L) {
            this.size.addAndGet(bytes);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Size set to %d bytes", this.size.get()));
        }
    }

    public Long getTransferred() {
        if (null == this.transferred) {
            return 0L;
        }
        return this.transferred.get();
    }

    public void addTransferred(long bytes) {
        if (null == this.transferred) {
            this.transferred = new AtomicLong(0L);
        }
        this.transferred.addAndGet(bytes);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Transferred set to %d bytes", this.transferred.get()));
        }
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public void setSize(Long bytes) {
        if (null == this.size) {
            this.size = new AtomicLong(0L);
        }
        this.size.set(bytes);
    }

    public void setTransferred(Long bytes) {
        if (null == this.transferred) {
            this.transferred = new AtomicLong(0L);
        }
        this.transferred.set(bytes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Transfer{");
        sb.append("transferred=").append(this.transferred);
        sb.append(", size=").append(this.size);
        sb.append(", roots=").append(this.roots);
        sb.append(", state=").append((Object)this.state);
        sb.append(", host=").append(this.host);
        sb.append('}');
        return sb.toString();
    }

    private static enum State {
        running,
        stopped;

    }

    public static enum Type {
        download{

            @Override
            public boolean isReloadable() {
                return true;
            }
        }
        ,
        upload{

            @Override
            public boolean isReloadable() {
                return true;
            }
        }
        ,
        sync{

            @Override
            public boolean isReloadable() {
                return true;
            }
        }
        ,
        copy{

            @Override
            public boolean isReloadable() {
                return true;
            }
        }
        ,
        move{

            @Override
            public boolean isReloadable() {
                return false;
            }
        };


        public abstract boolean isReloadable();
    }
}

