/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.CacheReference;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.unicode.NFCNormalizer;
import ch.cyberduck.core.unicode.UnicodeNormalizer;
import java.util.Objects;

public class SimplePathPredicate
implements CacheReference<Path> {
    private static final UnicodeNormalizer normalizer = new NFCNormalizer();
    private final AbstractPath.Type type;
    private final String path;

    public SimplePathPredicate(Path file) {
        this.type = file.isSymbolicLink() ? AbstractPath.Type.symboliclink : (file.isFile() ? AbstractPath.Type.file : AbstractPath.Type.directory);
        this.path = normalizer.normalize(file.getAbsolute()).toString();
    }

    public boolean equals(Object o) {
        if (null == o) {
            return false;
        }
        if (o instanceof CacheReference) {
            return this.hashCode() == o.hashCode();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.path});
    }

    @Override
    public boolean test(Path test) {
        return this.hashCode() == new SimplePathPredicate(test).hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SimplePathPredicate{");
        sb.append("type=").append((Object)this.type);
        sb.append(", path='").append(this.path).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

