/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AlphanumericRandomStringService;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.CredentialsConfigurator;
import ch.cyberduck.core.HostnameConfigurator;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.Serializable;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.features.Location;
import ch.cyberduck.core.local.DefaultLocalTouchFeature;
import ch.cyberduck.core.local.TemporaryFileServiceFactory;
import ch.cyberduck.core.serializer.Deserializer;
import ch.cyberduck.core.serializer.Serializer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class Profile
implements Protocol,
Serializable {
    private static final Logger log = Logger.getLogger(Profile.class);
    private final Deserializer<String> dict;
    private final Protocol parent;
    private final Local disk;
    private final Local icon;

    public Profile(Protocol parent, Deserializer<String> dict) {
        this.parent = parent;
        this.dict = dict;
        this.disk = this.write(this.value("Disk"));
        this.icon = this.write(this.value("Icon"));
    }

    @Override
    public <T> T serialize(Serializer dict) {
        throw new UnsupportedOperationException();
    }

    public Protocol getProtocol() {
        return this.parent;
    }

    @Override
    public String getPrefix() {
        return this.parent.getPrefix();
    }

    @Override
    public boolean isEnabled() {
        return StringUtils.isNotBlank((CharSequence)this.value("Protocol")) && StringUtils.isNotBlank((CharSequence)this.value("Vendor"));
    }

    @Override
    public boolean isSecure() {
        return this.getScheme().isSecure();
    }

    @Override
    public boolean isStateful() {
        return this.parent.isStateful();
    }

    @Override
    public String getIdentifier() {
        return this.parent.getIdentifier();
    }

    @Override
    public Protocol.Type getType() {
        return this.parent.getType();
    }

    @Override
    public String getUsernamePlaceholder() {
        String v = this.value("Username Placeholder");
        if (StringUtils.isBlank((CharSequence)v)) {
            return this.parent.getUsernamePlaceholder();
        }
        return LocaleFactory.localizedString(v, "Credentials");
    }

    @Override
    public String getPasswordPlaceholder() {
        String v = this.value("Password Placeholder");
        if (StringUtils.isBlank((CharSequence)v)) {
            return this.parent.getPasswordPlaceholder();
        }
        return LocaleFactory.localizedString(v, "Credentials");
    }

    @Override
    public String getTokenPlaceholder() {
        String v = this.value("Token Placeholder");
        if (StringUtils.isBlank((CharSequence)v)) {
            return this.parent.getTokenPlaceholder();
        }
        return LocaleFactory.localizedString(v, "Credentials");
    }

    @Override
    public String getDefaultHostname() {
        String v = this.value("Default Hostname");
        if (StringUtils.isBlank((CharSequence)v)) {
            return this.parent.getDefaultHostname();
        }
        return v;
    }

    @Override
    public String getProvider() {
        String v = this.value("Vendor");
        if (StringUtils.isBlank((CharSequence)v)) {
            return this.parent.getProvider();
        }
        return v;
    }

    @Override
    public boolean isBundled() {
        String v = this.value("Bundled");
        if (StringUtils.isBlank((CharSequence)v)) {
            return this.parent.isBundled();
        }
        return Boolean.valueOf(v);
    }

    @Override
    public String getName() {
        String v = this.value("Name");
        if (StringUtils.isBlank((CharSequence)v)) {
            return this.parent.getName();
        }
        return v;
    }

    @Override
    public String getDescription() {
        String v = this.value("Description");
        if (StringUtils.isBlank((CharSequence)v)) {
            return this.parent.getDescription();
        }
        return v;
    }

    @Override
    public int getDefaultPort() {
        String v = this.value("Default Port");
        if (StringUtils.isBlank((CharSequence)v)) {
            return this.parent.getDefaultPort();
        }
        try {
            return Integer.valueOf(v);
        }
        catch (NumberFormatException e) {
            log.warn((Object)String.format("Port %s is not a number", e.getMessage()));
            return this.parent.getDefaultPort();
        }
    }

    @Override
    public String getDefaultPath() {
        String v = this.value("Default Path");
        if (StringUtils.isBlank((CharSequence)v)) {
            return this.parent.getDefaultPath();
        }
        return v;
    }

    @Override
    public String getDefaultNickname() {
        String v = this.value("Default Nickname");
        if (StringUtils.isBlank((CharSequence)v)) {
            return this.parent.getDefaultNickname();
        }
        return v;
    }

    @Override
    public String getRegion() {
        String v = this.value("Region");
        if (StringUtils.isBlank((CharSequence)v)) {
            return this.parent.getRegion();
        }
        return v;
    }

    @Override
    public String disk() {
        if (null == this.disk) {
            return this.parent.disk();
        }
        return this.disk.getAbsolute();
    }

    @Override
    public String icon() {
        if (null == this.icon) {
            return this.parent.icon();
        }
        return this.icon.getAbsolute();
    }

    @Override
    public String favicon() {
        return this.parent.favicon();
    }

    private Local write(String icon) {
        if (StringUtils.isBlank((CharSequence)icon)) {
            return null;
        }
        byte[] favicon = Base64.decodeBase64((String)icon);
        Local file = TemporaryFileServiceFactory.get().create(new AlphanumericRandomStringService().random());
        try {
            new DefaultLocalTouchFeature().touch(file);
            try (OutputStream out = file.getOutputStream(false);){
                IOUtils.write((byte[])favicon, (OutputStream)out);
            }
            return file;
        }
        catch (AccessDeniedException | IOException e) {
            log.error((Object)"Error writing temporary file", (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean validate(Credentials credentials, LoginOptions options) {
        return this.parent.validate(credentials, options);
    }

    @Override
    public CredentialsConfigurator getCredentialsFinder() {
        return this.parent.getCredentialsFinder();
    }

    @Override
    public HostnameConfigurator getHostnameFinder() {
        return this.parent.getHostnameFinder();
    }

    @Override
    public Protocol.Case getCaseSensitivity() {
        return this.parent.getCaseSensitivity();
    }

    @Override
    public Scheme getScheme() {
        String v = this.value("Scheme");
        if (StringUtils.isBlank((CharSequence)v)) {
            return this.parent.getScheme();
        }
        try {
            return Scheme.valueOf(v);
        }
        catch (IllegalArgumentException e) {
            log.warn((Object)String.format("Unknown scheme %s", v));
            return null;
        }
    }

    @Override
    public String[] getSchemes() {
        List<String> values = this.list("Schemes");
        if (values.isEmpty()) {
            return this.parent.getSchemes();
        }
        return values.toArray(new String[values.size()]);
    }

    @Override
    public String getContext() {
        String v = this.value("Context");
        if (StringUtils.isBlank((CharSequence)v)) {
            return this.parent.getContext();
        }
        return v;
    }

    @Override
    public String getAuthorization() {
        String v = this.value("Authorization");
        if (StringUtils.isBlank((CharSequence)v)) {
            return this.parent.getAuthorization();
        }
        return v;
    }

    @Override
    public Set<Location.Name> getRegions() {
        List<String> regions = this.list("Regions");
        if (regions.isEmpty()) {
            return this.parent.getRegions();
        }
        HashSet<Location.Name> set = new HashSet<Location.Name>();
        for (String region : regions) {
            set.add(new Location.Name(region));
        }
        return set;
    }

    @Override
    public boolean isEncodingConfigurable() {
        return this.parent.isEncodingConfigurable();
    }

    @Override
    public boolean isAnonymousConfigurable() {
        if (StringUtils.isBlank((CharSequence)this.value("Anonymous Configurable"))) {
            return this.parent.isAnonymousConfigurable();
        }
        return this.bool("Anonymous Configurable");
    }

    @Override
    public boolean isUsernameConfigurable() {
        if (StringUtils.isBlank((CharSequence)this.value("Username Configurable"))) {
            return this.parent.isUsernameConfigurable();
        }
        return this.bool("Username Configurable");
    }

    @Override
    public boolean isPasswordConfigurable() {
        if (StringUtils.isBlank((CharSequence)this.value("Password Configurable"))) {
            return this.parent.isPasswordConfigurable();
        }
        return this.bool("Password Configurable");
    }

    @Override
    public boolean isTokenConfigurable() {
        if (StringUtils.isBlank((CharSequence)this.value("Token Configurable"))) {
            return this.parent.isTokenConfigurable();
        }
        return this.bool("Token Configurable");
    }

    @Override
    public boolean isOAuthConfigurable() {
        return StringUtils.isNotBlank((CharSequence)this.getOAuthClientId());
    }

    @Override
    public boolean isCertificateConfigurable() {
        if (StringUtils.isBlank((CharSequence)this.value("Certificate Configurable"))) {
            return this.parent.isCertificateConfigurable();
        }
        return this.bool("Certificate Configurable");
    }

    @Override
    public boolean isPrivateKeyConfigurable() {
        if (StringUtils.isBlank((CharSequence)this.value("Private Key Configurable"))) {
            return this.parent.isPrivateKeyConfigurable();
        }
        return this.bool("Private Key Configurable");
    }

    @Override
    public boolean isHostnameConfigurable() {
        if (StringUtils.isBlank((CharSequence)this.value("Hostname Configurable"))) {
            return this.parent.isHostnameConfigurable();
        }
        return this.bool("Hostname Configurable");
    }

    @Override
    public boolean isPortConfigurable() {
        if (StringUtils.isBlank((CharSequence)this.value("Port Configurable"))) {
            return this.parent.isPortConfigurable();
        }
        return this.bool("Port Configurable");
    }

    @Override
    public boolean isPathConfigurable() {
        if (StringUtils.isBlank((CharSequence)this.value("Path Configurable"))) {
            return this.parent.isPathConfigurable();
        }
        return this.bool("Path Configurable");
    }

    @Override
    public String getOAuthAuthorizationUrl() {
        String v = this.value("OAuth Authorization Url");
        if (StringUtils.isBlank((CharSequence)v)) {
            return this.parent.getOAuthAuthorizationUrl();
        }
        return v;
    }

    @Override
    public String getOAuthTokenUrl() {
        String v = this.value("OAuth Token Url");
        if (StringUtils.isBlank((CharSequence)v)) {
            return this.parent.getOAuthTokenUrl();
        }
        return v;
    }

    @Override
    public List<String> getOAuthScopes() {
        List<String> scopes = this.list("Scopes");
        if (scopes.isEmpty()) {
            return this.parent.getOAuthScopes();
        }
        return scopes;
    }

    @Override
    public String getOAuthRedirectUrl() {
        String v = this.value("OAuth Redirect Url");
        if (StringUtils.isBlank((CharSequence)v)) {
            return this.parent.getOAuthRedirectUrl();
        }
        return v;
    }

    @Override
    public String getOAuthClientId() {
        String v = this.value("OAuth Client ID");
        if (StringUtils.isBlank((CharSequence)v)) {
            return this.parent.getOAuthClientId();
        }
        return v;
    }

    @Override
    public String getOAuthClientSecret() {
        String v = this.value("OAuth Client Secret");
        if (StringUtils.isBlank((CharSequence)v)) {
            return this.parent.getOAuthClientSecret();
        }
        return v;
    }

    @Override
    public <T> T getFeature(Class<T> type) {
        return this.parent.getFeature(type);
    }

    @Override
    public boolean isUTCTimezone() {
        return this.parent.isUTCTimezone();
    }

    private String value(String key) {
        return this.dict.stringForKey(key);
    }

    private List<String> list(String key) {
        List<String> list = this.dict.listForKey(key);
        if (null == list) {
            return Collections.emptyList();
        }
        return list;
    }

    private boolean bool(String key) {
        return this.dict.booleanForKey(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Protocol)) {
            return false;
        }
        Protocol protocol = (Protocol)o;
        if (this.getIdentifier() != null ? !this.getIdentifier().equals(protocol.getIdentifier()) : protocol.getIdentifier() != null) {
            return false;
        }
        if (this.getScheme() != null ? !this.getScheme().equals((Object)protocol.getScheme()) : protocol.getScheme() != null) {
            return false;
        }
        if (this.getContext() != null ? !this.getContext().equals(protocol.getContext()) : protocol.getContext() != null) {
            return false;
        }
        if (this.getAuthorization() != null ? !this.getAuthorization().equals(protocol.getAuthorization()) : protocol.getAuthorization() != null) {
            return false;
        }
        if (this.getProvider() != null ? !this.getProvider().equals(protocol.getProvider()) : protocol.getProvider() != null) {
            return false;
        }
        return !(this.getDefaultHostname() != null ? !this.getDefaultHostname().equals(protocol.getDefaultHostname()) : protocol.getDefaultHostname() != null);
    }

    public int hashCode() {
        int result = this.getIdentifier() != null ? this.getIdentifier().hashCode() : 0;
        result = 31 * result + (this.getScheme() != null ? this.getScheme().hashCode() : 0);
        result = 31 * result + (this.getContext() != null ? this.getContext().hashCode() : 0);
        result = 31 * result + (this.getAuthorization() != null ? this.getAuthorization().hashCode() : 0);
        result = 31 * result + (this.getProvider() != null ? this.getProvider().hashCode() : 0);
        result = 31 * result + (this.getDefaultHostname() != null ? this.getDefaultHostname().hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(Protocol o) {
        return this.getIdentifier().compareTo(o.getIdentifier());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Profile{");
        sb.append("parent=").append(this.parent);
        sb.append(", vendor=").append(this.value("Vendor"));
        sb.append(", description=").append(this.value("Description"));
        sb.append(", image=").append(this.disk);
        sb.append('}');
        return sb.toString();
    }
}

