/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostPasswordStore;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.LoginService;
import ch.cyberduck.core.OAuthTokens;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.StringAppender;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.exception.LoginCanceledException;
import ch.cyberduck.core.exception.LoginFailureException;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.threading.CancelCallback;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class KeychainLoginService
implements LoginService {
    private static final Logger log = Logger.getLogger(KeychainLoginService.class);
    private final HostPasswordStore keychain;

    public KeychainLoginService(HostPasswordStore keychain) {
        this.keychain = keychain;
    }

    @Override
    public void validate(Host bookmark, String message, LoginCallback prompt, LoginOptions options) throws LoginCanceledException, LoginFailureException {
        Credentials credentials;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Validate login credentials for %s", bookmark));
        }
        if ((credentials = bookmark.getCredentials()).isPublicKeyAuthentication() && !credentials.getIdentity().attributes().getPermission().isReadable()) {
            log.warn((Object)String.format("Prompt to select identity file not readable %s", credentials.getIdentity()));
            credentials.setIdentity(prompt.select(credentials.getIdentity()));
        }
        if (options.keychain) {
            OAuthTokens tokens;
            String passphrase;
            String token;
            String password;
            if (options.password && StringUtils.isBlank((CharSequence)credentials.getPassword()) && StringUtils.isNotBlank((CharSequence)(password = this.keychain.findLoginPassword(bookmark)))) {
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Fetched password from keychain for %s", bookmark));
                }
                credentials.setSaved(false);
                credentials.setPassword(password);
            }
            if (options.token && StringUtils.isBlank((CharSequence)credentials.getToken()) && StringUtils.isNotBlank((CharSequence)(token = this.keychain.findLoginToken(bookmark)))) {
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Fetched token from keychain for %s", bookmark));
                }
                credentials.setSaved(false);
                credentials.setToken(token);
            }
            if (options.publickey && StringUtils.isNotBlank((CharSequence)(passphrase = this.keychain.findPrivateKeyPassphrase(bookmark)))) {
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Fetched private key passphrase from keychain for %s", bookmark));
                }
                credentials.setSaved(false);
                credentials.setIdentityPassphrase(passphrase);
            }
            if (options.oauth && (tokens = this.keychain.findOAuthTokens(bookmark)).validate()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Fetched OAuth token from keychain for %s", bookmark));
                }
                credentials.setSaved(false);
                credentials.setOauth(tokens);
            }
        }
        if (!credentials.validate(bookmark.getProtocol(), options)) {
            StringAppender details = new StringAppender();
            details.append(message);
            details.append(LocaleFactory.localizedString("No login credentials could be found in the Keychain", "Credentials"));
            this.prompt(bookmark, details.toString(), prompt, options);
        }
    }

    public boolean prompt(Host bookmark, String message, LoginCallback prompt, LoginOptions options) throws LoginCanceledException {
        Credentials input;
        Credentials credentials = bookmark.getCredentials();
        if (options.password) {
            input = prompt.prompt(bookmark, credentials.getUsername(), String.format("%s %s", LocaleFactory.localizedString("Login", "Login"), bookmark.getHostname()), message, options);
            credentials.setSaved(input.isSaved());
            credentials.setUsername(input.getUsername());
            credentials.setPassword(input.getPassword());
            credentials.setIdentity(input.getIdentity());
        }
        if (options.token) {
            input = prompt.prompt(bookmark, LocaleFactory.localizedString("Provide additional login credentials", "Credentials"), message, options);
            credentials.setSaved(input.isSaved());
            credentials.setToken(input.getPassword());
        }
        return options.password || options.token;
    }

    @Override
    public boolean authenticate(Proxy proxy, Session session, ProgressListener listener, LoginCallback prompt, CancelCallback cancel) throws BackgroundException {
        Host bookmark = session.getHost();
        Credentials credentials = bookmark.getCredentials();
        if (credentials.isPasswordAuthentication()) {
            listener.message(MessageFormat.format(LocaleFactory.localizedString("Authenticating as {0}", "Status"), credentials.getUsername()));
        } else if (credentials.isOAuthAuthentication()) {
            listener.message(MessageFormat.format(LocaleFactory.localizedString("Authenticating as {0}", "Status"), credentials.getOauth().getAccessToken()));
        } else if (credentials.isPublicKeyAuthentication()) {
            listener.message(MessageFormat.format(LocaleFactory.localizedString("Authenticating as {0}", "Status"), credentials.getIdentity().getName()));
        } else if (credentials.isCertificateAuthentication()) {
            listener.message(MessageFormat.format(LocaleFactory.localizedString("Authenticating as {0}", "Status"), credentials.getCertificate()));
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Attempt authentication for %s", bookmark));
            }
            session.login(proxy, prompt, cancel);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Login successful for session %s", session));
            }
            listener.message(LocaleFactory.localizedString("Login successful", "Credentials"));
            if (credentials.isSaved()) {
                try {
                    this.keychain.save(bookmark);
                }
                catch (LocalAccessDeniedException e) {
                    log.error((Object)String.format("Failure saving credentials for %s in keychain. %s", session, e.getDetail()));
                }
            } else if (log.isInfoEnabled()) {
                log.info((Object)String.format("Skip writing credentials for bookmark %s", bookmark.getHostname()));
            }
            credentials.setPassed(true);
            credentials.setPassword(null);
            credentials.setToken(null);
            credentials.setOauth(OAuthTokens.EMPTY);
            return true;
        }
        catch (LoginFailureException e) {
            listener.message(LocaleFactory.localizedString("Login failed", "Credentials"));
            credentials.setPassed(false);
            LoginOptions options = new LoginOptions(bookmark.getProtocol());
            StringAppender details = new StringAppender();
            details.append(LocaleFactory.localizedString("Login failed", "Credentials"));
            details.append(e.getDetail());
            if (this.prompt(bookmark, details.toString(), prompt, options)) {
                return false;
            }
            throw e;
        }
    }
}

