/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.storegate;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.VersionId;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.AbstractHttpWriteFeature;
import ch.cyberduck.core.http.DelayedHttpEntityCallable;
import ch.cyberduck.core.http.HttpExceptionMappingService;
import ch.cyberduck.core.http.HttpRange;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.shared.DefaultAttributesFinderFeature;
import ch.cyberduck.core.shared.DefaultFindFeature;
import ch.cyberduck.core.storegate.StoregateApiClient;
import ch.cyberduck.core.storegate.StoregateExceptionMappingService;
import ch.cyberduck.core.storegate.StoregateIdProvider;
import ch.cyberduck.core.storegate.StoregateSession;
import ch.cyberduck.core.storegate.io.swagger.client.ApiException;
import ch.cyberduck.core.storegate.io.swagger.client.JSON;
import ch.cyberduck.core.storegate.io.swagger.client.model.FileMetadata;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.joda.time.DateTime;

public class StoregateWriteFeature
extends AbstractHttpWriteFeature<VersionId> {
    private final StoregateSession session;
    private final StoregateIdProvider fileid;
    private final Find finder;
    private final AttributesFinder attributes;

    public StoregateWriteFeature(StoregateSession session, StoregateIdProvider nodeid) {
        this(session, nodeid, (Find)new DefaultFindFeature((Session)session), (AttributesFinder)new DefaultAttributesFinderFeature((Session)session));
    }

    public StoregateWriteFeature(StoregateSession session, StoregateIdProvider fileid, Find finder, AttributesFinder attributes) {
        super(finder, attributes);
        this.session = session;
        this.fileid = fileid;
        this.finder = finder;
        this.attributes = attributes;
    }

    public Write.Append append(Path file, Long length, Cache<Path> cache) throws BackgroundException {
        if (this.finder.withCache(cache).find(file)) {
            PathAttributes attr = this.attributes.withCache(cache).find(file);
            return new Write.Append(false, true).withSize(Long.valueOf(attr.getSize())).withChecksum(attr.getChecksum());
        }
        return Write.notfound;
    }

    public boolean temporary() {
        return false;
    }

    public boolean random() {
        return false;
    }

    public HttpResponseOutputStream<VersionId> write(final Path file, final TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        DelayedHttpEntityCallable<VersionId> command = new DelayedHttpEntityCallable<VersionId>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public VersionId call(AbstractHttpEntity entity) throws BackgroundException {
                try {
                    client = (StoregateApiClient)StoregateWriteFeature.access$000(StoregateWriteFeature.this).getClient();
                    request = new HttpPost(String.format("%s/v4/upload/resumable", new Object[]{client.getBasePath()}));
                    meta = new FileMetadata();
                    meta.setId("");
                    meta.setAttributes(0);
                    meta.setFlags(0);
                    meta.setLockId(status.getLockId() != null ? status.getLockId().toString() : "");
                    meta.setFileName(file.getName());
                    meta.setParentId(StoregateWriteFeature.access$100(StoregateWriteFeature.this).getFileid(file.getParent(), (ListProgressListener)new DisabledListProgressListener()));
                    meta.setFileSize(status.getLength());
                    meta.setCreated(new DateTime(file.attributes().getCreationDate()));
                    meta.setModified(new DateTime(file.attributes().getModificationDate()));
                    request.setEntity((HttpEntity)new StringEntity(new JSON().getContext(meta.getClass()).writeValueAsString((Object)meta), ContentType.create((String)"application/json", (String)"UTF-8")));
                    request.addHeader("Content-Type", "application/json; charset=UTF-8");
                    response = client.getClient().execute((HttpUriRequest)request);
                    try {
                        switch (response.getStatusLine().getStatusCode()) {
                            case 200: {
                                ** break;
lbl21:
                                // 1 sources

                                break;
                            }
                            default: {
                                throw new StoregateExceptionMappingService().map(new ApiException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), Collections.emptyMap(), EntityUtils.toString((HttpEntity)response.getEntity())));
                            }
                        }
                    }
                    finally {
                        EntityUtils.consume((HttpEntity)response.getEntity());
                    }
                    if (response.containsHeader("Location") == false) throw new StoregateExceptionMappingService().map(new ApiException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), Collections.emptyMap(), EntityUtils.toString((HttpEntity)response.getEntity())));
                    putTarget = response.getFirstHeader("Location").getValue();
                    put = new HttpPut(putTarget);
                    put.setEntity((HttpEntity)entity);
                    if (status.getLength() == 0L) {
                        header = "*/0";
                    } else {
                        range = HttpRange.byLength((long)0L, (long)status.getLength());
                        header = String.format("%d-%d/%d", new Object[]{range.getStart(), range.getEnd(), status.getLength()});
                    }
                    put.addHeader("Content-Range", String.format("bytes %s", new Object[]{header}));
                    putResponse = client.getClient().execute((HttpUriRequest)put);
                    try {
                        switch (putResponse.getStatusLine().getStatusCode()) {
                            case 200: 
                            case 201: {
                                result = (FileMetadata)new JSON().getContext(FileMetadata.class).readValue((Reader)new InputStreamReader(putResponse.getEntity().getContent(), StandardCharsets.UTF_8), FileMetadata.class);
                                var11_13 = new VersionId(result.getId());
                                return var11_13;
                            }
                        }
                        throw new StoregateExceptionMappingService().map(new ApiException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), Collections.emptyMap(), EntityUtils.toString((HttpEntity)response.getEntity())));
                    }
                    finally {
                        EntityUtils.consume((HttpEntity)putResponse.getEntity());
                    }
                }
                catch (IOException e) {
                    throw new HttpExceptionMappingService().map("Upload {0} failed", (Throwable)e, file);
                }
            }

            public long getContentLength() {
                return status.getLength();
            }
        };
        return this.write(file, status, (DelayedHttpEntityCallable)command);
    }

    static /* synthetic */ StoregateSession access$000(StoregateWriteFeature x0) {
        return x0.session;
    }

    static /* synthetic */ StoregateIdProvider access$100(StoregateWriteFeature x0) {
        return x0.fileid;
    }
}

