/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.storegate;

import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.storegate.StoregateExceptionMappingService;
import ch.cyberduck.core.storegate.StoregateIdProvider;
import ch.cyberduck.core.storegate.StoregateSession;
import ch.cyberduck.core.storegate.io.swagger.client.ApiClient;
import ch.cyberduck.core.storegate.io.swagger.client.ApiException;
import ch.cyberduck.core.storegate.io.swagger.client.api.FilesApi;
import java.util.List;

public class StoregateDeleteFeature
implements Delete {
    private final StoregateSession session;
    private final StoregateIdProvider fileid;

    public StoregateDeleteFeature(StoregateSession session, StoregateIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public void delete(List<Path> files, PasswordCallback prompt, Delete.Callback callback) throws BackgroundException {
        for (Path file : files) {
            try {
                callback.delete(file);
                FilesApi api = new FilesApi((ApiClient)this.session.getClient());
                api.filesDelete(this.fileid.getFileid(file, (ListProgressListener)new DisabledListProgressListener()));
            }
            catch (ApiException e) {
                throw new StoregateExceptionMappingService().map(e);
            }
        }
    }

    public boolean isRecursive() {
        return false;
    }
}

