/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.azure;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.azure.AzureExceptionMappingService;
import ch.cyberduck.core.azure.AzurePathContainerService;
import ch.cyberduck.core.azure.AzureSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.io.Checksum;
import com.microsoft.azure.storage.AccessCondition;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.BlobContainerProperties;
import com.microsoft.azure.storage.blob.BlobProperties;
import com.microsoft.azure.storage.blob.BlobRequestOptions;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import java.net.URISyntaxException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;

public class AzureAttributesFinderFeature
implements AttributesFinder {
    private final AzureSession session;
    private final OperationContext context;
    private final PathContainerService containerService = new AzurePathContainerService();

    public AzureAttributesFinderFeature(AzureSession session, OperationContext context) {
        this.session = session;
        this.context = context;
    }

    public PathAttributes find(Path file) throws BackgroundException {
        if (file.isRoot()) {
            return PathAttributes.EMPTY;
        }
        try {
            if (this.containerService.isContainer(file)) {
                PathAttributes attributes = new PathAttributes();
                CloudBlobContainer container = ((CloudBlobClient)this.session.getClient()).getContainerReference(this.containerService.getContainer(file).getName());
                container.downloadAttributes(null, null, this.context);
                BlobContainerProperties properties = container.getProperties();
                attributes.setETag(properties.getEtag());
                attributes.setModificationDate(properties.getLastModified().getTime());
                return attributes;
            }
            CloudBlob blob = ((CloudBlobClient)this.session.getClient()).getContainerReference(this.containerService.getContainer(file).getName()).getBlobReferenceFromServer(this.containerService.getKey(file));
            BlobRequestOptions options = new BlobRequestOptions();
            blob.downloadAttributes(AccessCondition.generateEmptyCondition(), options, this.context);
            BlobProperties properties = blob.getProperties();
            PathAttributes attributes = new PathAttributes();
            attributes.setSize(properties.getLength());
            attributes.setModificationDate(properties.getLastModified().getTime());
            if (StringUtils.isNotBlank((CharSequence)properties.getContentMD5())) {
                attributes.setChecksum(Checksum.parse((String)Hex.encodeHexString((byte[])Base64.decodeBase64((String)properties.getContentMD5()))));
            }
            attributes.setETag(properties.getEtag());
            return attributes;
        }
        catch (StorageException e) {
            throw new AzureExceptionMappingService().map("Failure to read attributes of {0}", e, file);
        }
        catch (URISyntaxException e) {
            throw new NotfoundException(e.getMessage(), (Throwable)e);
        }
    }
}

