/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dav;

import ch.cyberduck.core.dav.DAVTimestampFeature;
import com.github.sardine.impl.handler.MultiStatusResponseHandler;
import com.github.sardine.model.Collection;
import com.github.sardine.model.Creationdate;
import com.github.sardine.model.Displayname;
import com.github.sardine.model.Getcontentlength;
import com.github.sardine.model.Getcontenttype;
import com.github.sardine.model.Getetag;
import com.github.sardine.model.Getlastmodified;
import com.github.sardine.model.Multistatus;
import com.github.sardine.model.Prop;
import com.github.sardine.model.Propstat;
import com.github.sardine.model.Resourcetype;
import com.github.sardine.model.Response;
import com.github.sardine.util.SardineUtil;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SaxPropFindResponseHandler
extends MultiStatusResponseHandler {
    protected Multistatus getMultistatus(InputStream stream) throws IOException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        try {
            SAXParser saxParser = spf.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            SaxHandler handler = new SaxHandler();
            xmlReader.setContentHandler(handler);
            xmlReader.parse(new InputSource(stream));
            return handler.getMultistatus();
        }
        catch (Exception e) {
            throw new IOException("Not a valid DAV response", e);
        }
    }

    private static final class SaxHandler
    extends DefaultHandler {
        private Multistatus multistatus;
        private Response response;
        private Propstat propstat;
        private Prop prop;
        private Resourcetype type;
        private StringBuilder data;
        private Element root;

        private SaxHandler() {
        }

        @Override
        public void startDocument() {
            this.multistatus = new Multistatus();
            this.root = SardineUtil.createElement((QName)SardineUtil.createQNameWithCustomNamespace((String)"root"));
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            switch (localName) {
                case "response": {
                    this.response = new Response();
                    this.multistatus.getResponse().add(this.response);
                    break;
                }
                case "propstat": {
                    this.propstat = new Propstat();
                    this.response.getPropstat().add(this.propstat);
                    break;
                }
                case "prop": {
                    this.prop = new Prop();
                    this.propstat.setProp(this.prop);
                    break;
                }
                case "resourcetype": {
                    this.type = new Resourcetype();
                    this.prop.setResourcetype(this.type);
                    break;
                }
                case "collection": {
                    this.type.setCollection(new Collection());
                }
            }
            this.data = new StringBuilder();
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.data.append(new String(ch, start, length));
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (localName.equals("status")) {
                this.propstat.setStatus(this.data.toString());
            } else if (localName.equals("creationdate")) {
                Creationdate value = new Creationdate();
                value.getContent().add(this.data.toString());
                this.prop.setCreationdate(value);
            } else if (localName.equals("displayname")) {
                Displayname value = new Displayname();
                value.getContent().add(this.data.toString());
                this.prop.setDisplayname(value);
            } else if (localName.equals("getcontentlength")) {
                Getcontentlength value = new Getcontentlength();
                value.getContent().add(this.data.toString());
                this.prop.setGetcontentlength(value);
            } else if (localName.equals("getcontenttype")) {
                Getcontenttype value = new Getcontenttype();
                value.getContent().add(this.data.toString());
                this.prop.setGetcontenttype(value);
            } else if (localName.equals("getlastmodified")) {
                Getlastmodified value = new Getlastmodified();
                value.getContent().add(this.data.toString());
                this.prop.setGetlastmodified(value);
            } else if (localName.equals("getetag")) {
                Getetag value = new Getetag();
                value.getContent().add(this.data.toString());
                this.prop.setGetetag(value);
            } else if (localName.equals("lastmodified_server")) {
                Element element = SardineUtil.createElement((Element)this.root, (QName)DAVTimestampFeature.LAST_MODIFIED_SERVER_CUSTOM_NAMESPACE);
                element.setTextContent(this.data.toString());
                this.prop.getAny().add(element);
            } else if (localName.equals("lastmodified")) {
                Element element = SardineUtil.createElement((Element)this.root, (QName)DAVTimestampFeature.LAST_MODIFIED_CUSTOM_NAMESPACE);
                element.setTextContent(this.data.toString());
                this.prop.getAny().add(element);
            } else if (localName.equals("href")) {
                this.response.getHref().add(this.data.toString());
            } else if (!uri.equals("DAV:")) {
                Element element = SardineUtil.createElement((Element)this.root, (QName)new QName(uri, localName, "d"));
                element.setTextContent(this.data.toString());
                this.prop.getAny().add(element);
            }
        }

        public Multistatus getMultistatus() {
            return this.multistatus;
        }
    }
}

